/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.cordovasim.eclipse.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.jboss.tools.vpe.cordovasim.eclipse.cordova.plugin.internal.Plugin;

public class CordovaFileUtil {
    private static final String PLUGINS_DIR = "plugins";
    private static final String CORDOVA = ".cordova";
    private static final String CONFIG_JSON = "config.json";
    private static final String FILE = "\"file\": ";
    private static final String ID = "\"id\": ";
    private static final String CLOBBERS = "\"clobbers\": [\n";
    private static final String MERGES = "\"merges\": [\n";
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String CORDOVA_PLUGINS_JS_BEGINNING = "cordova.define('cordova/plugin_list', function(require, exports, module) { \n module.exports = [\n";
    private static final String CORDOVA_PLUGINS_JS_END = "]\n});";
    private static final String CORDOVA_DEFINE = "cordova.define(";
    private static final String FUNCTION_BEGINNING = "function(require, exports, module) {\n";
    private static final String FUNCTION_END = "});";

    public static List<File> getPluginXmlFiles(File pluginsDir) {
        if (pluginsDir != null && pluginsDir.exists()) {
            File[] pluginDirs;
            ArrayList<File> pluginXmlFiles = new ArrayList<File>();
            File[] fileArray = pluginDirs = pluginsDir.listFiles();
            int n = pluginDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File pluginDir = fileArray[n2];
                if (pluginDir.isDirectory()) {
                    File pluginXmlFile = new File(pluginDir, PLUGIN_XML);
                    if (pluginDir.exists()) {
                        pluginXmlFiles.add(pluginXmlFile);
                    }
                }
                ++n2;
            }
            return pluginXmlFiles;
        }
        return null;
    }

    public static String generateCordovaPluginsJsContent(List<Plugin> plugins) {
        if (plugins != null && !plugins.isEmpty()) {
            String pluginContent = "";
            Iterator<Plugin> pluginIterator = plugins.iterator();
            while (pluginIterator.hasNext()) {
                Plugin plugin = pluginIterator.next();
                pluginContent = String.valueOf(pluginContent) + "\n\t{\n";
                pluginContent = String.valueOf(pluginContent) + "\t\t\"file\": \"" + plugin.getFile() + "\",\n";
                pluginContent = String.valueOf(pluginContent) + "\t\t\"id\": \"" + plugin.getId() + "\",\n";
                Iterator<String> mapperIterator = null;
                if (plugin.getClobbers().size() > 0) {
                    pluginContent = String.valueOf(pluginContent) + "\t\t\"clobbers\": [\n";
                    mapperIterator = plugin.getClobbers().iterator();
                } else if (plugin.getMerges().size() > 0) {
                    pluginContent = String.valueOf(pluginContent) + "\t\t\"merges\": [\n";
                    mapperIterator = plugin.getMerges().iterator();
                }
                while (mapperIterator.hasNext()) {
                    String clobber = (String)mapperIterator.next();
                    pluginContent = String.valueOf(pluginContent) + "\t\t\t\"" + clobber + "\"";
                    pluginContent = mapperIterator.hasNext() ? String.valueOf(pluginContent) + ",\n" : String.valueOf(pluginContent) + "\n\t\t]";
                }
                pluginContent = pluginIterator.hasNext() ? String.valueOf(pluginContent) + "\n\t}," : String.valueOf(pluginContent) + "\n\t}\n";
            }
            return CORDOVA_PLUGINS_JS_BEGINNING + pluginContent + CORDOVA_PLUGINS_JS_END;
        }
        return null;
    }

    public static String getDefaultCordovaPluginJsContent() {
        return "cordova.define('cordova/plugin_list', function(require, exports, module) { \n module.exports = [\nmodule.exports = []]\n});";
    }

    public static String generatePluginContent(File file, String pluginId) throws FileNotFoundException {
        String content = null;
        if (file != null && file.exists()) {
            String fileContent = new Scanner(file).useDelimiter("\\A").next();
            content = "cordova.define(\"" + pluginId + '\"' + ", " + FUNCTION_BEGINNING + fileContent + FUNCTION_END;
        }
        return content;
    }

    public static File getPluginDir(String resourceBase) {
        File pluginDir;
        File parentDir = CordovaFileUtil.getParentDir(resourceBase);
        if (parentDir != null && (pluginDir = new File(parentDir, PLUGINS_DIR)).exists()) {
            return pluginDir;
        }
        return null;
    }

    public static File getConfigJson(String resourceBase) {
        File configJson;
        File cordovaDir;
        File parentDir = CordovaFileUtil.getParentDir(resourceBase);
        if (parentDir != null && (cordovaDir = new File(parentDir, CORDOVA)).exists() && (configJson = new File(cordovaDir, CONFIG_JSON)).exists()) {
            return configJson;
        }
        return null;
    }

    private static File getParentDir(String childDir) {
        File file = new File(childDir);
        if (file.exists()) {
            return file.getParentFile();
        }
        return null;
    }
}

