/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.ui.contentassist;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.utils.HTMLTernPrinter;
import tern.eclipse.jface.contentassist.TernCompletionProposal;
import tern.server.protocol.completions.Parameter;
import tern.server.protocol.completions.TernCompletionItem;

public class JSTernCompletionProposal
extends TernCompletionProposal {
    private static final String COMMA = ",";
    private IRegion fSelectedRegion;
    private int[] fArgumentOffsets;
    private int[] fArgumentLengths;
    private ITextViewer fTextViewer;
    private boolean fReplacementStringComputed;
    private boolean fToggleEating;

    public JSTernCompletionProposal(String name, String type, String doc, String url, String origin, int pos, int startOffset) {
        super(name, type, doc, url, origin, pos, startOffset);
    }

    protected Image getDefaultImage() {
        return TernUIPlugin.getTernDescriptorManager().getImage((TernCompletionItem)this);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        if (this.fTextViewer == null) {
            this.fTextViewer = viewer;
        }
        Point selection = viewer.getSelectedRange();
        this.fToggleEating = (stateMask & SWT.MOD1) != 0;
        int newLength = selection.x + selection.y - this.getReplacementOffset();
        if (this.insertCompletion() ^ this.fToggleEating && newLength >= 0) {
            this.setReplacementLength(newLength);
        }
        this.apply(document, trigger, offset);
        this.fToggleEating = false;
    }

    private boolean insertCompletion() {
        return true;
    }

    public void apply(IDocument document, char trigger, int offset) {
        super.apply(document, trigger, offset);
        int baseOffset = this.getReplacementOffset();
        String replacement = this.getReplacementString();
        if (this.fArgumentOffsets != null && this.getTextViewer() != null) {
            try {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i != this.fArgumentOffsets.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, baseOffset + this.fArgumentOffsets[i], this.fArgumentLengths[i], -1));
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(')', document));
                ui.setDoContextInfo(true);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException badLocationException) {}
        } else {
            this.fSelectedRegion = new Region(baseOffset + replacement.length(), 0);
        }
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    public final String getReplacementString() {
        if (!this.fReplacementStringComputed) {
            this.setReplacementString(this.computeReplacementString());
        }
        return super.getReplacementString();
    }

    public final void setReplacementString(String replacementString) {
        this.fReplacementStringComputed = true;
        super.setReplacementString(replacementString);
    }

    protected String computeReplacementString() {
        List parameters = super.getParameters();
        if (parameters == null) {
            return super.getReplacementString();
        }
        int count = parameters.size();
        this.fArgumentOffsets = new int[count];
        this.fArgumentLengths = new int[count];
        StringBuilder buffer = new StringBuilder(String.valueOf(super.getName()));
        buffer.append("(");
        this.setCursorPosition(buffer.length());
        String paramName = null;
        int i = 0;
        while (i != count) {
            if (i != 0) {
                buffer.append(COMMA);
            }
            paramName = ((Parameter)parameters.get(i)).getName();
            this.fArgumentOffsets[i] = buffer.length();
            buffer.append(paramName);
            this.fArgumentLengths[i] = paramName.length();
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String getAdditionalProposalInfo() {
        return HTMLTernPrinter.getAdditionalProposalInfo((TernCompletionItem)this, null);
    }

    protected Shell getActiveWorkbenchShell() {
        return TernUIPlugin.getActiveWorkbenchShell();
    }

    protected static final class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        private final IDocument fDocument;

        public ExitPolicy(char exitCharacter, IDocument document) {
            this.fExitCharacter = exitCharacter;
            this.fDocument = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter) {
                if (environment.anyPositionContains(offset)) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                return new LinkedModeUI.ExitFlags(2, true);
            }
            switch (event.character) {
                case ';': {
                    return new LinkedModeUI.ExitFlags(0, true);
                }
                case '\r': {
                    if (offset > 0) {
                        try {
                            if (this.fDocument.getChar(offset - 1) == '{') {
                                return new LinkedModeUI.ExitFlags(1, true);
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

