/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.ui.validation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import tern.eclipse.ide.core.IIDETernProject;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.internal.ui.Trace;
import tern.eclipse.ide.internal.ui.validation.DirtyRegionProcessor;
import tern.eclipse.ide.internal.ui.validation.TernAnnotation;
import tern.server.ITernPlugin;
import tern.server.TernPlugin;
import tern.server.protocol.TernQuery;
import tern.server.protocol.lint.ITernLintCollector;
import tern.server.protocol.lint.TernLintQuery;

public final class JavaDirtyRegionProcessor
extends DirtyRegionProcessor {
    private final ITextEditor editor;
    private final IFile file;
    private final IIDETernProject ternProject;

    public JavaDirtyRegionProcessor(ITextEditor editor, IFile resource) throws CoreException {
        this.editor = editor;
        this.file = resource;
        this.ternProject = TernCorePlugin.getTernProject((IProject)resource.getProject());
    }

    @Override
    public synchronized void startReconciling() {
        super.startReconciling();
    }

    @Override
    protected void endProcessing() {
        IDocument document = this.getDocument();
        if (document != null && this.ternProject.hasPlugin((ITernPlugin)TernPlugin.lint)) {
            TernLintQuery query = new TernLintQuery();
            final ArrayList<TernAnnotation> annotationsToRemove = new ArrayList<TernAnnotation>();
            final IAnnotationModel newModel = this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput());
            Iterator iterator = newModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (!(annotation instanceof TernAnnotation)) continue;
                annotationsToRemove.add((TernAnnotation)annotation);
            }
            ITernLintCollector collector = new ITernLintCollector(){

                public void addMessage(String message, Long start, Long end, String severity) {
                    TernAnnotation existingAnnotation = this.getExistingAnnotation(message, start.intValue(), end.intValue(), severity, annotationsToRemove);
                    if (existingAnnotation != null) {
                        annotationsToRemove.remove((Object)existingAnnotation);
                    } else {
                        TernAnnotation annotation = new TernAnnotation(severity, message, start.intValue(), end.intValue());
                        newModel.addAnnotation((Annotation)annotation, new Position(annotation.getStart(), annotation.getEnd() - annotation.getStart()));
                    }
                }

                private TernAnnotation getExistingAnnotation(String message, int start, int end, String severity, List<TernAnnotation> annotationsToRemove2) {
                    for (TernAnnotation annotation : annotationsToRemove2) {
                        if (!annotation.isEquals(severity, message, start, end)) continue;
                        return annotation;
                    }
                    return null;
                }
            };
            try {
                this.ternProject.request((TernQuery)query, this.file, document, collector);
            }
            catch (Exception e) {
                Trace.trace((byte)3, "Error while tern validation.", e);
            }
            for (TernAnnotation ternAnnotation : annotationsToRemove) {
                newModel.removeAnnotation((Annotation)ternAnnotation);
            }
        }
    }
}

