/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.testng.eclipse.launch.components.ITestContent;
import org.testng.eclipse.ui.util.TypeParser;
import org.testng.eclipse.util.signature.IMethodDescriptor;
import org.testng.eclipse.util.signature.MethodDescriptor;
import org.testng.reporters.XMLStringBuffer;

public class SuiteBuilder {
    public static File createSuite(IJavaProject ijp, IType[] types, IJavaElement ije) {
        XMLStringBuffer xmlSuite = SuiteBuilder.getSuiteBuffer(ije.getElementName());
        if (5 == ije.getElementType()) {
            SuiteBuilder.createClassTest(types, ije, xmlSuite);
        } else if (7 == ije.getElementType()) {
            SuiteBuilder.createClassTest(types, ije, xmlSuite);
        } else if (9 == ije.getElementType()) {
            SuiteBuilder.createMethodTest(types, ije, xmlSuite);
        }
        xmlSuite.pop("suite");
        String projectPath = ijp.getProject().getLocation().toOSString();
        File file = new File(projectPath, String.valueOf(ije.getElementName()) + ".xml");
        SuiteBuilder.ppp("saving to file " + file.getAbsolutePath());
        SuiteBuilder.saveFileContent(file, xmlSuite);
        return file;
    }

    private static void createClassTest(IType[] types, IJavaElement ije, XMLStringBuffer buf) {
        String testName = "Test " + ije.getElementName();
        Properties attrs = new Properties();
        attrs.setProperty("name", testName);
        Properties clsAttrs = new Properties();
        int i = 0;
        while (i < types.length) {
            ITestContent content = TypeParser.parseType(types[i]);
            if (content.hasTestMethods()) {
                if (i == 0) {
                    buf.push("test", attrs);
                    buf.push("classes");
                }
                clsAttrs.setProperty("name", types[i].getFullyQualifiedName());
                buf.push("class", clsAttrs);
                buf.pop("class");
            }
            ++i;
        }
        buf.pop("classes");
        buf.pop("test");
    }

    private static void createMethodTest(IType[] types, IJavaElement ije, XMLStringBuffer buf) {
        String testName = "Method test " + ije.getElementName();
        Properties attrs = new Properties();
        attrs.setProperty("name", testName);
        IType type = types[0];
        ITestContent content = TypeParser.parseType(type);
        if (!content.hasTestMethods()) {
            return;
        }
        Set<IMethodDescriptor> testMethods = content.getTestMethods();
        MethodDescriptor testMethodDescriptor = new MethodDescriptor((IMethod)ije);
        Properties methodAttrs = new Properties();
        for (IMethodDescriptor imd : testMethods) {
            if (!imd.equals(testMethodDescriptor)) continue;
            methodAttrs.setProperty("name", imd.getName());
        }
        buf.push("test", attrs);
        buf.push("methods");
        buf.push("method", methodAttrs);
        buf.pop("method");
        buf.pop("methods");
        buf.push("classes");
        Properties clsAttrs = new Properties();
        clsAttrs.setProperty("name", type.getFullyQualifiedName());
        buf.push("class", clsAttrs);
        buf.pop("class");
        buf.pop("classes");
        buf.pop("test");
    }

    private static XMLStringBuffer getSuiteBuffer(String name) {
        XMLStringBuffer xmlBuf = new XMLStringBuffer();
        xmlBuf.setDocType("suite SYSTEM http://testng.org/testng-1.0.dtd");
        Properties attrs = new Properties();
        attrs.setProperty("name", name);
        xmlBuf.push("suite", attrs);
        return xmlBuf;
    }

    private static final void saveFileContent(File file, XMLStringBuffer xmlBuffer) {
        block23: {
            FileWriter fw = null;
            BufferedWriter bw = null;
            try {
                try {
                    fw = new FileWriter(file);
                    bw = new BufferedWriter(fw);
                    bw.write(xmlBuffer.getStringBuffer().toString());
                    bw.flush();
                }
                catch (IOException iOException) {
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException iOException3) {}
                    }
                    bw = null;
                    fw = null;
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException iOException) {}
                }
                bw = null;
                fw = null;
                throw throwable;
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
            bw = null;
            fw = null;
        }
    }

    private static void ppp(Object msg) {
        System.out.println("[SuiteBuilder]: " + msg);
    }
}

