/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import java.io.File;
import java.util.Random;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.testng.eclipse.util.StringUtils;

public class PreferenceStoreUtil {
    private IPreferenceStore m_storage;

    public PreferenceStoreUtil(IPreferenceStore storage) {
        this.m_storage = storage;
    }

    public void storeOutputDir(String projectName, String outdir, boolean isAbsolute) {
        this.m_storage.setValue(String.valueOf(projectName) + ".outdir", outdir);
        this.m_storage.setValue(String.valueOf(projectName) + ".absolutepath", isAbsolute);
    }

    public void storeDisabledListeners(String projectName, boolean selection) {
        this.m_storage.setValue(String.valueOf(projectName) + ".disabledListeners", selection);
    }

    public void storeUseProjectJar(String projectName, boolean selection) {
        this.m_storage.setValue(String.valueOf(projectName) + ".useProjectJar", selection);
    }

    public void storeXmlTemplateFile(String projectName, String xmlFile) {
        this.m_storage.setValue(String.valueOf(projectName) + "xmlTemplateFile", xmlFile);
    }

    public void storePreDefinedListeners(String projectName, String listeners) {
        this.m_storage.setValue(String.valueOf(projectName) + "preDefinedListeners", listeners);
    }

    public String getExcludedStackTraces(String projectName) {
        return this.getString(projectName, false, "excludedStackTraces");
    }

    public File getTemporaryDirectory() {
        Random r = new Random(System.currentTimeMillis());
        File result = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separatorChar + "testng-eclipse-" + r.nextInt());
        return result;
    }

    public String getXmlTemplateFile(String projectName, boolean projectOnly) {
        return this.getString(projectName, projectOnly, "xmlTemplateFile");
    }

    public String getPreDefinedListeners(String projectName, boolean projectOnly) {
        return this.getString(projectName, projectOnly, "preDefinedListeners");
    }

    public IPath getOutputDirectoryPath(IJavaProject project) {
        String projectName = project.getElementName();
        String outdir = this.getOutputDir(projectName, false);
        boolean isAbsolute = this.isOutputAbsolutePath(projectName, false);
        return new Path(isAbsolute ? outdir : String.valueOf(project.getPath().toOSString()) + "/" + outdir);
    }

    public IPath getOutputAbsolutePath(IJavaProject project) {
        String projectName = project.getElementName();
        String outdir = this.getOutputDir(projectName, false);
        boolean isAbsolute = this.isOutputAbsolutePath(projectName, false);
        return new Path(isAbsolute ? outdir : String.valueOf(project.getProject().getLocation().toOSString()) + "/" + outdir);
    }

    public String getOutputDir(String projectName, boolean projectOnly) {
        String result = this.getString(projectName, projectOnly, ".outdir");
        if (StringUtils.isEmptyString(result)) {
            String outDir;
            if (this.m_storage.contains("generalOutput")) {
                this.m_storage.setValue("generalOutput", "");
                this.m_storage.setValue(".outdir", this.m_storage.getString("generalOutput"));
            }
            result = !"".equals(outDir = this.m_storage.getString(".outdir")) ? outDir : "test-output";
        }
        return result;
    }

    public boolean isOutputAbsolutePath(String projectName, boolean projectOnly) {
        if (projectOnly || this.m_storage.contains(String.valueOf(projectName) + ".absolutepath")) {
            return this.m_storage.getBoolean(String.valueOf(projectName) + ".absolutepath");
        }
        if (this.m_storage.contains("generalOutputRelative")) {
            this.m_storage.setValue("generalOutputRelative", false);
            this.m_storage.setValue(".absolutepath", this.m_storage.getBoolean("generalOutputRelative"));
        }
        return this.m_storage.getBoolean(".absolutepath");
    }

    private String getString(String projectName, boolean projectOnly, String prefName) {
        String result = "";
        if (this.m_storage.contains(String.valueOf(projectName) + prefName)) {
            result = this.m_storage.getString(String.valueOf(projectName) + prefName);
        }
        if (StringUtils.isEmptyString(result) && !projectOnly) {
            result = this.m_storage.getString(prefName);
        }
        return result;
    }

    public boolean hasDisabledListeners(String projectName, boolean projectOnly) {
        if (projectOnly || this.m_storage.contains(String.valueOf(projectName) + ".disabledListeners")) {
            return this.m_storage.getBoolean(String.valueOf(projectName) + ".disabledListeners");
        }
        return this.m_storage.getBoolean(".disabledListeners");
    }

    public boolean getUseProjectJar(String projectName) {
        return this.m_storage.getBoolean(String.valueOf(projectName) + ".useProjectJar");
    }

    public boolean getWatchResults(String projectName) {
        return this.m_storage.getBoolean(String.valueOf(projectName) + ".watchResults");
    }

    public String getWatchResultDirectory(String projectName) {
        return this.m_storage.getString(String.valueOf(projectName) + ".watchResultDirectory");
    }

    public void storeWatchResults(String projectName, boolean selection) {
        this.m_storage.setValue(String.valueOf(projectName) + ".watchResults", selection);
    }

    public void storeWatchResultLocation(String projectName, String text) {
        this.m_storage.setValue(String.valueOf(projectName) + ".watchResultDirectory", text);
    }

    public void storeSuiteMethodTreatement(int value) {
        this.m_storage.setValue("suiteMethodTreatment", value);
    }

    public SuiteMethodTreatment getSuiteMethodTreatement() {
        int n = this.m_storage.getInt("suiteMethodTreatment");
        SuiteMethodTreatment result = SuiteMethodTreatment.REMOVE;
        switch (n) {
            case 1: {
                result = SuiteMethodTreatment.COMMENT_OUT;
                break;
            }
            case 2: {
                result = SuiteMethodTreatment.DONT_TOUCH;
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SuiteMethodTreatment {
        REMOVE("Remove"),
        COMMENT_OUT("Comment out"),
        DONT_TOUCH("Don't touch");

        private String m_label;

        private SuiteMethodTreatment(String label) {
            this.m_label = label;
        }

        public String getLabel() {
            return this.m_label;
        }
    }
}

