/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.launch.TestNGLaunchConfigurationConstants;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.util.ConfigurationHelper;
import org.testng.eclipse.util.DependencyInfo;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.PreferenceStoreUtil;
import org.testng.eclipse.util.param.ParameterSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchUtil {
    private static final List<String> EMPTY_ARRAY_PARAM = Lists.newArrayList();

    public static void launchFailedSuiteConfiguration(IJavaProject javaProject, String runMode) {
        LaunchUtil.launchFailedSuiteConfiguration(javaProject, runMode, null, null);
    }

    public static void launchFailedSuiteConfiguration(IJavaProject javaProject, String runMode, ILaunchConfiguration prevConfig, Set failureDescriptions) {
        String suiteConfName = String.valueOf(javaProject.getElementName()) + "-" + "testng-failed.xml";
        String suiteFilePath = String.valueOf(TestNGPlugin.getPluginPreferenceStore().getOutputAbsolutePath(javaProject).toOSString()) + "/" + "testng-failed.xml";
        LaunchUtil.launchSuiteConfiguration(javaProject.getProject(), suiteConfName, suiteFilePath, runMode, prevConfig, failureDescriptions);
    }

    public static void launchSuiteConfiguration(IFile suiteFile, String mode) {
        LaunchUtil.launchSuiteConfiguration(suiteFile, mode, null, null);
    }

    public static void launchSuiteConfiguration(IFile suiteFile, String mode, ILaunchConfiguration prevConfig, Set failureDescriptions) {
        IProject project = suiteFile.getProject();
        String fileConfName = suiteFile.getProjectRelativePath().toString().replace('/', '.');
        String suitePath = suiteFile.getLocation().toOSString();
        LaunchUtil.launchSuiteConfiguration(project, fileConfName, suitePath, mode, prevConfig, failureDescriptions);
    }

    private static void launchSuiteConfiguration(IProject project, String fileConfName, String suiteFilePath, String mode, ILaunchConfiguration prevConfig, Set failureDescriptions) {
        ILaunchConfigurationWorkingCopy configWC = LaunchUtil.createLaunchConfiguration(project, fileConfName, null);
        try {
            if (prevConfig != null) {
                Map previousEnv = prevConfig.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                configWC.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, previousEnv);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        configWC.setAttribute(TestNGLaunchConfigurationConstants.SUITE_TEST_LIST, Collections.singletonList(suiteFilePath));
        configWC.setAttribute(TestNGLaunchConfigurationConstants.TYPE, TestNGLaunchConfigurationConstants.LaunchType.SUITE.ordinal());
        String jargs = ConfigurationHelper.getJvmArgs(prevConfig);
        if (jargs != null) {
            ConfigurationHelper.setJvmArgs(configWC, jargs);
        }
        if (failureDescriptions != null && failureDescriptions.size() > 0) {
            Iterator it = failureDescriptions.iterator();
            StringBuffer buf = new StringBuffer();
            boolean first = true;
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(",");
                }
                buf.append(it.next());
            }
            LaunchUtil.setFailedTestsJvmArg(buf.toString(), configWC);
        }
        LaunchUtil.runConfig(configWC, mode);
    }

    public static void launchMapConfiguration(IProject project, String configName, Map<String, Map> launchAttributes, ICompilationUnit compilationUnit, String launchMode) {
        ILaunchConfigurationWorkingCopy workingCopy = LaunchUtil.createLaunchConfiguration(project, configName, null);
        try {
            launchAttributes.putAll(workingCopy.getAttributes());
        }
        catch (CoreException ce) {
            TestNGPlugin.log(ce);
        }
        if (compilationUnit != null) {
            Map params = LaunchUtil.solveParameters((IJavaElement)compilationUnit);
            launchAttributes.put(TestNGLaunchConfigurationConstants.PARAMS, params);
        }
        workingCopy.setAttributes(launchAttributes);
        LaunchUtil.runConfig(workingCopy, launchMode);
    }

    public static Map<String, Object> createClassLaunchConfigurationMap(IType mainType, IType[] types, String annotationType) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        ArrayList classNames = Lists.newArrayList();
        ArrayListMultimap classMethods = ArrayListMultimap.create();
        classMethods.get(null);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            classNames.add(type.getFullyQualifiedName());
            ++n2;
        }
        attrs.put(TestNGLaunchConfigurationConstants.TYPE, TestNGLaunchConfigurationConstants.LaunchType.CLASS.ordinal());
        attrs.put(TestNGLaunchConfigurationConstants.CLASS_TEST_LIST, classNames);
        attrs.put(TestNGLaunchConfigurationConstants.ALL_METHODS_LIST, ConfigurationHelper.toClassMethodsMap(classMethods.asMap()));
        return attrs;
    }

    public static void launchPackageConfiguration(IJavaProject ijp, IPackageFragment ipf, String mode) {
        ArrayList<String> packageNames = new ArrayList<String>();
        packageNames.add(ipf.getElementName());
        try {
            if (LaunchUtil.findGroupDependencies(ipf.getCompilationUnits()).length > 0) {
                LaunchUtil.groupDependencyWarning("package " + ipf.getElementName(), null);
            }
        }
        catch (JavaModelException javaModelException) {}
        ILaunchConfigurationWorkingCopy workingCopy = LaunchUtil.createLaunchConfiguration(ijp.getProject(), "package " + ipf.getElementName(), null);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.CLASS_TEST_LIST, EMPTY_ARRAY_PARAM);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.METHOD_TEST_LIST, EMPTY_ARRAY_PARAM);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.PACKAGE_TEST_LIST, packageNames);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.TYPE, TestNGLaunchConfigurationConstants.LaunchType.PACKAGE.ordinal());
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.ALL_METHODS_LIST, ConfigurationHelper.toClassMethodsMap(new HashMap<String, Collection<String>>()));
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.PARAMS, LaunchUtil.solveParameters((IJavaElement)ipf));
        String projectName = ijp.getProject().getName();
        PreferenceStoreUtil storage = TestNGPlugin.getPluginPreferenceStore();
        String preDefinedListeners = storage.getPreDefinedListeners(projectName, false);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.PRE_DEFINED_LISTENERS, preDefinedListeners.toString().trim());
        LaunchUtil.runConfig(workingCopy, mode);
    }

    public static void launchMethodConfiguration(IJavaProject javaProject, IMethod imethod, String runMode) {
        LaunchUtil.launchMethodConfiguration(javaProject, imethod, runMode, null);
    }

    private static boolean methodHasDependencies(IMethod method) throws JavaModelException {
        IAnnotation annotation = method.getAnnotation("Test");
        return annotation != null && (LaunchUtil.contains(annotation.getMemberValuePairs(), "dependsOnGroups") || LaunchUtil.contains(annotation.getMemberValuePairs(), "dependsOnMethods"));
    }

    private static boolean contains(IMemberValuePair[] memberValuePairs, String string) {
        IMemberValuePair[] iMemberValuePairArray = memberValuePairs;
        int n = memberValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair pair = iMemberValuePairArray[n2];
            if (string.equals(pair.getMemberName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void launchMethodConfiguration(IJavaProject javaProject, IMethod iMethod, String runMode, RunInfo runInfo) {
        HashSet methods = Sets.newHashSet((Object[])new IMethod[]{iMethod});
        try {
            if (LaunchUtil.methodHasDependencies(iMethod)) {
                DependencyInfo groupInfo = DependencyInfo.createDependencyInfo(javaProject);
                methods.addAll(LaunchUtil.findMethodTransitiveClosure(iMethod, groupInfo));
            }
        }
        catch (JavaModelException e) {
            TestNGPlugin.log(e);
        }
        LaunchUtil.launchMethodBasedConfiguration(javaProject, methods.toArray(new IMethod[methods.size()]), runMode, runInfo);
    }

    private static void groupDependencyWarning(String elementName, Set<String> groups) {
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"WARNING", (String)(String.valueOf(elementName) + " defines group dependencies that will be ignored. To reliably test methods with group dependencies use a suite definition."), (IStatus)new Status(2, "org.testng.eclipse", 3333, String.valueOf(elementName) + " uses group dependencies " + (groups != null ? groups.toString() : "") + " which due to a plugin limitation will be ignored", null));
    }

    private static void launchMethodBasedConfiguration(IJavaProject ijp, IMethod[] methods, String runMode, RunInfo runInfo) {
        ArrayList methodNames = Lists.newArrayList();
        ArrayListMultimap classMethods = ArrayListMultimap.create();
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            methodNames.add(method.getElementName());
            classMethods.put((Object)method.getDeclaringType().getFullyQualifiedName(), (Object)method.getElementName());
            ++n2;
        }
        HashSet<IType> typesSet = new HashSet<IType>();
        IMethod[] iMethodArray2 = methods;
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            IMethod method = iMethodArray2[n];
            typesSet.add(method.getDeclaringType());
            ++n;
        }
        IType[] types = typesSet.toArray(new IType[typesSet.size()]);
        ArrayList<String> typeNames = new ArrayList<String>();
        IType[] iTypeArray = types;
        int n4 = types.length;
        int n5 = 0;
        while (n5 < n4) {
            IType type = iTypeArray[n5];
            typeNames.add(type.getFullyQualifiedName());
            ++n5;
        }
        String name = String.valueOf(types[0].getTypeQualifiedName().toString()) + "." + ((String)methodNames.get(0)).toString();
        ILaunchConfigurationWorkingCopy workingCopy = LaunchUtil.createLaunchConfiguration(ijp.getProject(), name, runInfo);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.CLASS_TEST_LIST, typeNames);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.METHOD_TEST_LIST, (List)methodNames);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.PACKAGE_TEST_LIST, EMPTY_ARRAY_PARAM);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.TYPE, TestNGLaunchConfigurationConstants.LaunchType.METHOD.ordinal());
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.ALL_METHODS_LIST, ConfigurationHelper.toClassMethodsMap(classMethods.asMap()));
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.PARAMS, LaunchUtil.solveParameters((IJavaElement[])methods));
        String projectName = ijp.getProject().getName();
        PreferenceStoreUtil storage = TestNGPlugin.getPluginPreferenceStore();
        String preDefinedListeners = storage.getPreDefinedListeners(projectName, false);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.PRE_DEFINED_LISTENERS, preDefinedListeners.toString().trim());
        if (runInfo != null) {
            Map envVars;
            String jargs = runInfo.getJvmArgs();
            if (jargs != null) {
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, jargs);
            }
            if ((envVars = runInfo.getEnvironmentVariables()) != null) {
                workingCopy.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, envVars);
            }
            LaunchUtil.setFailedTestsJvmArg(runInfo.getTestDescription(), workingCopy);
        }
        LaunchUtil.runConfig(workingCopy, runMode);
    }

    public static void launchTypeConfiguration(IJavaProject ijp, IType type, String mode) {
        LaunchUtil.launchTypeBasedConfiguration(ijp, type.getElementName(), new IType[]{type}, mode);
    }

    public static void launchCompilationUnitConfiguration(IJavaProject ijp, List<ICompilationUnit> units, String mode) {
        ArrayList types = Lists.newArrayList();
        IType mainType = null;
        for (ICompilationUnit icu : units) {
            try {
                IType[] iTypeArray = icu.getTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    types.add(type);
                    ++n2;
                }
            }
            catch (JavaModelException jme) {
                TestNGPlugin.log((IStatus)new Status(4, "org.testng.eclipse", 1001, "No types in compilation unit " + icu.getElementName(), (Throwable)jme));
            }
            if (types == null) {
                return;
            }
            mainType = icu.findPrimaryType();
        }
        LaunchUtil.launchTypeBasedConfiguration(ijp, LaunchUtil.createConfName(mainType, units.size()), types.toArray(new IType[types.size()]), mode);
    }

    private static String createConfName(IType mainType, int unitCount) {
        String result = mainType.getElementName();
        if (unitCount > 1) {
            result = String.valueOf(result) + ", ...";
        }
        return result;
    }

    public static void launchTypesConfiguration(IJavaProject project, List<IType> types, String mode) {
        LaunchUtil.launchTypeBasedConfiguration(project, LaunchUtil.createConfName(types.get(0), types.size()), types.toArray(new IType[types.size()]), mode);
    }

    public static boolean useStringProtocol(ILaunchConfiguration configuration) {
        String jvmArgs = ConfigurationHelper.getJvmArgs(configuration);
        return jvmArgs.indexOf("-Dtestng.eclipse.stringprotocol") >= 0;
    }

    private static void launchTypeBasedConfiguration(IJavaProject javaProject, String confName, IType[] types, String mode) {
        ArrayListMultimap classMethods = ArrayListMultimap.create();
        ArrayList typeNames = Lists.newArrayList();
        HashSet allTypes = Sets.newHashSet();
        allTypes.addAll(Arrays.asList(types));
        HashSet allMethods = Sets.newHashSet();
        Object[] groupDependencies = LaunchUtil.findGroupDependencies(types);
        if (groupDependencies.length > 0) {
            DependencyInfo groupInfo = DependencyInfo.createDependencyInfo(javaProject);
            Set<IType> closure = LaunchUtil.findTypeTransitiveClosure(types, groupInfo);
            allTypes.addAll(closure);
            Set<IMethod> methods = LaunchUtil.findMethodTransitiveClosure(types, groupInfo);
            allMethods.addAll(methods);
        }
        for (IType type : allTypes) {
            typeNames.add(type.getFullyQualifiedName());
        }
        ArrayList methodNames = Lists.newArrayList();
        for (IMethod m : allMethods) {
            methodNames.add(m.getElementName());
            classMethods.put((Object)m.getDeclaringType().getFullyQualifiedName(), (Object)m.getElementName());
        }
        ILaunchConfigurationWorkingCopy workingCopy = LaunchUtil.createLaunchConfiguration(javaProject.getProject(), confName, null);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.TYPE, TestNGLaunchConfigurationConstants.LaunchType.CLASS.ordinal());
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.ALL_METHODS_LIST, ConfigurationHelper.toClassMethodsMap(classMethods.asMap()));
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.CLASS_TEST_LIST, (List)typeNames);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.PARAMS, LaunchUtil.solveParameters((IJavaElement[])allTypes.toArray(new IType[allTypes.size()])));
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.METHOD_TEST_LIST, (List)methodNames);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.PACKAGE_TEST_LIST, EMPTY_ARRAY_PARAM);
        String projectName = javaProject.getProject().getName();
        PreferenceStoreUtil storage = TestNGPlugin.getPluginPreferenceStore();
        String preDefinedListeners = storage.getPreDefinedListeners(projectName, false);
        workingCopy.setAttribute(TestNGLaunchConfigurationConstants.PRE_DEFINED_LISTENERS, preDefinedListeners.toString().trim());
        LaunchUtil.runConfig(workingCopy, mode);
    }

    public static Set<IMethod> findMethodTransitiveClosure(IType[] types, DependencyInfo groupInfo) {
        HashSet result = Sets.newHashSet();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            result.addAll(LaunchUtil.findMethodTransitiveClosure(type, groupInfo));
            ++n2;
        }
        return result;
    }

    public static Set<IMethod> findMethodTransitiveClosure(IType type, DependencyInfo groupInfo) {
        HashSet result = Sets.newHashSet();
        try {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                result.addAll(LaunchUtil.findMethodTransitiveClosure(method, groupInfo));
                ++n2;
            }
        }
        catch (JavaModelException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static Set<IMethod> findMethodTransitiveClosure(IMethod startMethod, DependencyInfo groupInfo) {
        HashSet result = Sets.newHashSet();
        HashSet currentMethods = Sets.newHashSet();
        currentMethods.add(startMethod);
        HashSet nextMethods = Sets.newHashSet();
        HashSet initialGroups = Sets.newHashSet();
        while (!currentMethods.isEmpty()) {
            for (IMethod method : currentMethods) {
                result.add(method);
                Collection groups = groupInfo.groupDependenciesByMethods.get((Object)method);
                if (groups != null) {
                    if (initialGroups.isEmpty()) {
                        initialGroups.addAll(groups);
                    }
                    for (String group : groups) {
                        Collection depMethods = groupInfo.methodsByGroups.get((Object)group);
                        if (depMethods != null) {
                            for (IMethod depMethod : depMethods) {
                                if (result.contains(depMethod)) continue;
                                result.add(depMethod);
                                nextMethods.add(depMethod);
                            }
                            continue;
                        }
                        System.out.println("Can't find any method defining the group " + group);
                    }
                } else {
                    System.out.println("No groups depended upon by method: " + method.getElementName());
                }
                Collection depMethods = groupInfo.methodsByMethods.get((Object)method);
                if (depMethods == null) continue;
                for (IMethod dm : depMethods) {
                    if (result.contains(dm)) continue;
                    result.add(dm);
                    nextMethods.add(dm);
                }
            }
            currentMethods.clear();
            currentMethods.addAll(nextMethods);
            nextMethods.clear();
        }
        StringBuilder sb = new StringBuilder();
        for (IMethod m : result) {
            sb.append(m.getDeclaringType().getFullyQualifiedName()).append(".").append(m.getElementName()).append(" ");
        }
        TestNGPlugin.log("Transitive closure for method " + startMethod.getElementName() + ": " + sb.toString());
        return result;
    }

    private static Set<IType> findTypeTransitiveClosure(IType[] types, DependencyInfo groupInfo) {
        HashSet result = Sets.newHashSet();
        HashSet currentTypes = Sets.newHashSet();
        currentTypes.addAll(Arrays.asList(types));
        HashSet nextTypes = Sets.newHashSet();
        HashSet initialGroups = Sets.newHashSet();
        while (!currentTypes.isEmpty()) {
            for (IType type : currentTypes) {
                result.add(type);
                Collection groups = groupInfo.groupDependenciesByTypes.get((Object)type);
                if (groups != null) {
                    if (initialGroups.isEmpty()) {
                        initialGroups.addAll(groups);
                    }
                    for (String group : groups) {
                        Collection depTypes = groupInfo.typesByGroups.get((Object)group);
                        if (depTypes != null) {
                            for (IType depType : depTypes) {
                                if (result.contains(depType)) continue;
                                result.add(depType);
                                nextTypes.add(depType);
                            }
                            continue;
                        }
                        System.out.println("Can't find any types defining the group " + group);
                    }
                    continue;
                }
                System.out.println("No groups depended upon by type: " + type.getElementName());
            }
            currentTypes.clear();
            currentTypes.addAll(nextTypes);
            nextTypes.clear();
        }
        StringBuilder sb = new StringBuilder();
        for (IType type : result) {
            sb.append(type.getFullyQualifiedName()).append(" ");
        }
        TestNGPlugin.log("Transitive closure for groups \"" + initialGroups + "\":" + sb.toString());
        return result;
    }

    private static Object[] findGroupDependencies(ICompilationUnit[] units) {
        ArrayList resources = Lists.newArrayList();
        ICompilationUnit[] iCompilationUnitArray = units;
        int n = units.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit unit = iCompilationUnitArray[n2];
            try {
                resources.add(unit.getCorrespondingResource());
            }
            catch (JavaModelException javaModelException) {}
            ++n2;
        }
        IResource[] scopeResources = resources.toArray(new IResource[resources.size()]);
        FileSearchQuery query = new FileSearchQuery("@Test\\(.*\\s*dependsOnGroups\\s*=.*", true, true, FileTextSearchScope.newSearchScope((IResource[])scopeResources, (String[])new String[]{"*.java"}, (boolean)false));
        query.run((IProgressMonitor)new NullProgressMonitor());
        FileSearchResult result = (FileSearchResult)query.getSearchResult();
        Object[] elements = result.getElements();
        return elements;
    }

    private static Object[] findGroupDependencies(IType[] types) {
        ICompilationUnit[] units = new ICompilationUnit[types.length];
        int i = 0;
        while (i < types.length) {
            units[i] = types[i].getCompilationUnit();
            ++i;
        }
        return LaunchUtil.findGroupDependencies(units);
    }

    private static ILaunchConfigurationWorkingCopy createLaunchConfiguration(IProject project, String confName, RunInfo runInfo) {
        ILaunchManager launchManager = LaunchUtil.getLaunchManager();
        ILaunchConfiguration config = ConfigurationHelper.findConfiguration(launchManager, project, confName, runInfo);
        ILaunchConfigurationWorkingCopy configWC = null;
        if (config != null) {
            try {
                configWC = config.getWorkingCopy();
            }
            catch (CoreException cex) {
                TestNGPlugin.log((IStatus)new Status(4, "org.testng.eclipse", 1001, "Cannot create working copy of existing launcher " + config.getName(), (Throwable)cex));
            }
        }
        if (configWC == null) {
            if (confName == null && runInfo != null) {
                confName = String.valueOf(runInfo.getClassName()) + "." + runInfo.getMethodName();
            }
            configWC = ConfigurationHelper.createBasicConfiguration(launchManager, project, confName);
        }
        return configWC;
    }

    private static void runConfig(ILaunchConfigurationWorkingCopy launchConfiguration, String runMode) {
        ILaunchConfiguration conf = LaunchUtil.save(launchConfiguration);
        if (conf != null) {
            DebugUITools.launch((ILaunchConfiguration)conf, (String)runMode);
        }
    }

    private static ILaunchConfiguration save(ILaunchConfigurationWorkingCopy launchWorkingCopy) {
        if (launchWorkingCopy == null) {
            return null;
        }
        try {
            return launchWorkingCopy.doSave();
        }
        catch (CoreException cex) {
            TestNGPlugin.log(cex);
            return null;
        }
    }

    private static List<JDTUtil.MethodDefinition> solveDependsOn(IMethod imethod) {
        return JDTUtil.solveDependencies(imethod);
    }

    private static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private static Map solveParameters(IJavaElement[] javaElements) {
        Map result = ParameterSolver.solveParameters(javaElements);
        return result != null ? result : new HashMap();
    }

    private static Map solveParameters(IJavaElement javaElement) {
        return LaunchUtil.solveParameters(new IJavaElement[]{javaElement});
    }

    private static String[] getJavaLikeExtensions() {
        char[][] exts = Util.getJavaLikeExtensions();
        if (exts != null && exts.length > 0) {
            String[] extStrs = new String[exts.length];
            int i = 0;
            while (i < exts.length) {
                extStrs[i] = "*." + String.valueOf(exts[i]);
                ++i;
            }
            return extStrs;
        }
        return new String[]{"*.java"};
    }

    public static ILaunchConfigurationWorkingCopy setFailedTestsJvmArg(String value, ILaunchConfigurationWorkingCopy config) {
        try {
            String key = TestNGPlugin.getFailedTestsKey();
            String jvmargs = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            String newarg = String.valueOf(key) + "=\"" + value + "\" ";
            if (!key.startsWith("-D")) {
                newarg = "-D" + newarg;
            }
            newarg = value == "" ? " " : " " + newarg;
            if (jvmargs.equals("")) {
                config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, newarg);
            } else if (jvmargs.indexOf(key) == -1) {
                config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, String.valueOf(jvmargs) + newarg);
            } else {
                int start = jvmargs.indexOf(key);
                int next = jvmargs.indexOf("-D", start + 1);
                StringBuffer buf = new StringBuffer();
                buf.append(newarg).append(jvmargs.substring(0, start));
                if (next > start) {
                    buf.append(jvmargs.substring(next));
                }
                config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, buf.toString());
            }
        }
        catch (CoreException coreException) {}
        return config;
    }

    public static ILaunchConfigurationWorkingCopy addJvmArg(String key, String value, ILaunchConfigurationWorkingCopy config) {
        try {
            String jvmargs = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            String newarg = String.valueOf(key) + "=\"" + value + "\" ";
            if (!key.startsWith("-D")) {
                newarg = "-D" + newarg;
            }
            newarg = value == "" ? " " : " " + newarg;
            if (jvmargs.equals("")) {
                config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, newarg);
            } else if (jvmargs.indexOf(key) == -1) {
                config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, String.valueOf(jvmargs) + newarg);
            } else {
                int start = jvmargs.indexOf(key);
                int next = jvmargs.indexOf("-D", start + 1);
                StringBuffer buf = new StringBuffer();
                buf.append(newarg).append(jvmargs.substring(0, start));
                if (next > start) {
                    buf.append(jvmargs.substring(next));
                }
                config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, buf.toString());
            }
        }
        catch (CoreException coreException) {}
        return config;
    }

    public static void errorDialog(String string, Throwable ex) {
        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Fatal error", (String)(String.valueOf(string) + (ex.getMessage() != null ? ": " + ex.getMessage() : "")), (IStatus)new Status(4, "org.testng.eclipse", 0, "Status Error Message", null));
        TestNGPlugin.log(ex);
    }
}

