/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.testng.eclipse.launch.components.Filters;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.TestSearchEngine;

public class DependencyInfo {
    Multimap<String, IType> typesByGroups = ArrayListMultimap.create();
    Multimap<IType, String> groupDependenciesByTypes = ArrayListMultimap.create();
    Multimap<String, IMethod> methodsByGroups = ArrayListMultimap.create();
    Multimap<IMethod, String> groupDependenciesByMethods = ArrayListMultimap.create();
    Multimap<IMethod, IMethod> methodsByMethods = ArrayListMultimap.create();

    public static DependencyInfo createDependencyInfo(final IJavaProject javaProject) {
        final DependencyInfo result = new DependencyInfo();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                HashSet allTypes = Sets.newHashSet();
                try {
                    monitor.beginTask("Launching", 2000);
                    monitor.subTask("Calculating dependencies");
                    TestSearchEngine.collectTypes(javaProject, monitor, allTypes, Filters.SINGLE_TEST, "Parsing tests");
                    monitor.subTask("Collecting group information");
                    monitor.worked(1);
                    for (IType type : allTypes) {
                        IMethod[] iMethodArray = type.getMethods();
                        int n = iMethodArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMethod method = iMethodArray[n2];
                            IAnnotation[] iAnnotationArray = method.getAnnotations();
                            int n3 = iAnnotationArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IAnnotation annotation = iAnnotationArray[n4];
                                monitor.worked(1);
                                IMemberValuePair[] pairs = annotation.getMemberValuePairs();
                                if ("Test".equals(annotation.getElementName()) && pairs.length > 0) {
                                    IMemberValuePair[] iMemberValuePairArray = pairs;
                                    int n5 = pairs.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        Object dependencies;
                                        Object o;
                                        int n7;
                                        IMemberValuePair pair = iMemberValuePairArray[n6];
                                        if ("groups".equals(pair.getMemberName())) {
                                            Object groups = pair.getValue();
                                            if (groups.getClass().isArray()) {
                                                Object[] objectArray = (Object[])groups;
                                                n7 = objectArray.length;
                                                int n8 = 0;
                                                while (n8 < n7) {
                                                    o = objectArray[n8];
                                                    result.typesByGroups.put((Object)o.toString(), (Object)type);
                                                    result.methodsByGroups.put((Object)o.toString(), (Object)method);
                                                    ++n8;
                                                }
                                            } else {
                                                result.typesByGroups.put((Object)groups.toString(), (Object)type);
                                                result.methodsByGroups.put((Object)groups.toString(), (Object)method);
                                            }
                                        } else if ("dependsOnGroups".equals(pair.getMemberName())) {
                                            dependencies = pair.getValue();
                                            if (dependencies.getClass().isArray()) {
                                                Object[] objectArray = (Object[])dependencies;
                                                n7 = objectArray.length;
                                                int n9 = 0;
                                                while (n9 < n7) {
                                                    o = objectArray[n9];
                                                    result.groupDependenciesByTypes.put((Object)type, (Object)o.toString());
                                                    result.groupDependenciesByMethods.put((Object)method, (Object)o.toString());
                                                    ++n9;
                                                }
                                            } else {
                                                result.groupDependenciesByTypes.put((Object)type, (Object)dependencies.toString());
                                                result.groupDependenciesByMethods.put((Object)method, (Object)dependencies.toString());
                                            }
                                        } else if ("dependsOnMethods".equals(pair.getMemberName())) {
                                            dependencies = pair.getValue();
                                            IType methodType = method.getDeclaringType();
                                            if (dependencies.getClass().isArray()) {
                                                Object[] objectArray = (Object[])dependencies;
                                                int n10 = objectArray.length;
                                                n7 = 0;
                                                while (n7 < n10) {
                                                    Object o2 = objectArray[n7];
                                                    IMethod depMethod = JDTUtil.fuzzyFindMethodInTypeHierarchy(methodType, o2.toString(), new String[0]);
                                                    result.methodsByMethods.put((Object)method, (Object)depMethod);
                                                    ++n7;
                                                }
                                            } else {
                                                IMethod depMethod = JDTUtil.fuzzyFindMethodInTypeHierarchy(methodType, dependencies.toString(), new String[0]);
                                                result.methodsByMethods.put((Object)method, (Object)depMethod);
                                            }
                                        }
                                        ++n6;
                                    }
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }
}

