/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.summary;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.testng.eclipse.ui.OpenTestAction;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.TestRunTab;
import org.testng.eclipse.ui.TestRunnerViewPart;
import org.testng.eclipse.ui.summary.AbstractTableSorter;
import org.testng.eclipse.ui.summary.RunInfoFilter;
import org.testng.eclipse.ui.summary.RunInfoTableSorter;
import org.testng.eclipse.ui.summary.StringFilter;
import org.testng.eclipse.ui.summary.StringTableSorter;
import org.testng.remote.strprotocol.SuiteMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryTab
extends TestRunTab {
    private Map<String, RunInfo> m_tests = Maps.newHashMap();
    private TableViewer m_testViewer;
    private Map<String, TestResult> m_testResults = Maps.newHashMap();
    private TableViewer m_excludedMethodViewer;
    private List<ExcludedMethod> m_excludedMethodsModel = Lists.newArrayList();
    private RunInfoFilter m_testSearchFilter;
    private StringFilter m_excludedMethodFilter;
    private String m_selectedId;
    private TestRunnerViewPart m_testRunnerPart;

    @Override
    public String getTooltipKey() {
        return "Summary.tab.tooltip";
    }

    @Override
    public String getNameKey() {
        return "Summary.tab.title";
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public Composite createTabControl(Composite parent, TestRunnerViewPart runner) {
        this.m_testRunnerPart = runner;
        Composite result = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        result.setLayout((Layout)gridLayout);
        this.createLabel(result, "Tests");
        this.createTestViewer(result);
        this.createLabel(result, "Excluded methods");
        this.createExcludedMethodViewer(result);
        return result;
    }

    private void createLabel(Composite parent, String text) {
        Label result = new Label(parent, 0);
        result.setText(text);
        result.setFont(JFaceResources.getBannerFont());
        result.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
    }

    private void createExcludedMethodViewer(Composite result) {
        this.m_excludedMethodFilter = new StringFilter();
        this.m_excludedMethodViewer = this.createViewer(result, new String[]{"Class name", "Method name", "Description"}, new int[]{300, 250, 300}, new StringTableSorter(this), this.m_excludedMethodFilter);
        this.m_excludedMethodViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                this.handleDoubleClick(e);
            }

            private void handleDoubleClick(MouseEvent e) {
                TableItem[] items = ((Table)e.getSource()).getSelection();
                if (items.length > 0) {
                    ExcludedMethod em = (ExcludedMethod)items[0].getData();
                    System.out.println("Double click " + em.packageName + "." + em.methodName);
                    OpenTestAction openAction = new OpenTestAction(SummaryTab.this.m_testRunnerPart, em.packageName, em.methodName, true);
                    openAction.run();
                }
            }
        });
        this.m_excludedMethodViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                ExcludedMethod em = (ExcludedMethod)element;
                switch (columnIndex) {
                    case 0: {
                        return em.packageName;
                    }
                    case 1: {
                        return em.methodName;
                    }
                    case 2: {
                        return em.description;
                    }
                }
                return "";
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.m_excludedMethodViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }
        });
    }

    private String[] parseFqn(String fqn) {
        String packageName = fqn;
        String className = fqn;
        int ind = fqn.lastIndexOf(".");
        if (ind >= 0) {
            packageName = fqn.substring(0, ind);
            className = fqn.substring(ind + 1);
        }
        return new String[]{packageName, className};
    }

    private void createTestViewer(Composite result) {
        this.m_testSearchFilter = new RunInfoFilter();
        this.m_testViewer = this.createViewer(result, new String[]{"Test name", "Time (seconds)", "Class count", "Method count"}, new int[]{150, 150, 100, 100}, new RunInfoTableSorter(this), this.m_testSearchFilter);
        this.m_testViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss;
                RunInfo selected;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && (selected = (RunInfo)(ss = (StructuredSelection)selection).getFirstElement()) != null) {
                    String selectedId = ((RunInfo)ss.getFirstElement()).getTestId();
                    if (SummaryTab.this.m_selectedId != null && !SummaryTab.this.m_selectedId.startsWith(selectedId)) {
                        SummaryTab.this.m_selectedId = selectedId;
                    }
                }
            }
        });
        this.m_testViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return SummaryTab.this.m_tests.values().toArray();
            }
        });
        this.m_testViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                RunInfo runInfo = (RunInfo)element;
                String testId = runInfo.getTestId();
                switch (columnIndex) {
                    case 0: {
                        return ((RunInfo)element).getTestName();
                    }
                    case 1: {
                        return MessageFormat.format("{0}", Float.valueOf((float)SummaryTab.this.getTestTime(testId) / 1000.0f));
                    }
                    case 2: {
                        return Integer.toString(SummaryTab.this.getTestClassCount(testId));
                    }
                    case 3: {
                        return Integer.toString(SummaryTab.this.getTestMethodCount(testId));
                    }
                }
                return "";
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.m_testViewer.setInput(this.m_tests);
    }

    private TableViewer createViewer(Composite parent, String[] columns, int[] bounds, final AbstractTableSorter tableSorter, ViewerFilter filter) {
        final TableViewer result = new TableViewer(parent);
        final Table table = result.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        result.setSorter((ViewerSorter)tableSorter);
        int i = 0;
        while (i < columns.length) {
            final int index = i;
            TableViewerColumn viewerColumn = new TableViewerColumn(result, 0);
            final TableColumn column = viewerColumn.getColumn();
            column.setText(columns[i]);
            column.setWidth(bounds[i]);
            column.setResizable(true);
            column.setMoveable(true);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (tableSorter != null) {
                        tableSorter.setColumn(index);
                    }
                    int dir = table.getSortDirection();
                    dir = table.getSortColumn() == column ? (dir == 128 ? 1024 : 128) : 1024;
                    table.setSortDirection(dir);
                    table.setSortColumn(column);
                    result.refresh();
                }
            });
            ++i;
        }
        result.setFilters(new ViewerFilter[]{filter});
        return result;
    }

    protected int getTestMethodCount(String testId) {
        return this.m_testResults.get((Object)testId).methods.size();
    }

    public long getTestTime(String testId) {
        return this.m_testResults.get((Object)testId).time;
    }

    public int getTestClassCount(String testId) {
        return this.m_testResults.get((Object)testId).classes.size();
    }

    @Override
    public String getSelectedTestId() {
        return this.m_selectedId;
    }

    @Override
    public void setSelectedTest(String id) {
        if (id == null) {
            return;
        }
        this.m_selectedId = id;
        for (String test : this.m_testResults.keySet()) {
            if (!id.startsWith(test)) continue;
            this.m_testViewer.setSelection((ISelection)new StructuredSelection((Object)this.m_tests.get(test)));
        }
    }

    @Override
    public void updateTestResult(RunInfo runInfo, boolean expand) {
        String testId = runInfo.getTestId();
        this.m_tests.put(testId, runInfo);
        TestResult tr = this.m_testResults.get(testId);
        if (tr == null) {
            tr = new TestResult();
            this.m_testResults.put(testId, tr);
        }
        tr.time = tr.time + runInfo.getTime();
        tr.methods.add(runInfo.getMethodId());
        tr.classes.add(runInfo.getClassId());
        this.m_testViewer.refresh();
    }

    @Override
    public void updateTestResult(List<RunInfo> results) {
        if (results.size() > 0) {
            this.aboutToStart();
            for (RunInfo ri : results) {
                this.updateTestResult(ri, false);
            }
        }
    }

    @Override
    public void aboutToStart() {
        this.m_tests.clear();
        this.m_testResults.clear();
        this.m_testViewer.refresh();
        this.m_excludedMethodViewer.getTable().clearAll();
    }

    @Override
    public void updateSearchFilter(String text) {
        this.m_testSearchFilter.setFilter(text);
        this.m_testViewer.refresh();
        this.m_excludedMethodFilter.setFilter(text);
        this.m_excludedMethodViewer.refresh();
    }

    public void setExcludedMethodsModel(SuiteMessage message) {
        this.m_excludedMethodsModel.clear();
        for (String method : message.getExcludedMethods()) {
            ExcludedMethod em = new ExcludedMethod();
            String[] parsed = this.parseFqn(method);
            em.packageName = parsed[0];
            em.methodName = parsed[1];
            em.description = message.getDescriptionForMethod(method);
            this.m_excludedMethodsModel.add(em);
        }
        this.m_excludedMethodViewer.getTable().getDisplay().syncExec(new Runnable(){

            public void run() {
                SummaryTab.this.m_excludedMethodViewer.setInput((Object)SummaryTab.this.m_excludedMethodsModel);
                SummaryTab.this.m_excludedMethodViewer.refresh();
            }
        });
    }

    private class ExcludedMethod {
        public String packageName;
        public String methodName;
        public String description;

        private ExcludedMethod() {
        }
    }

    static class TestResult {
        Long time = 0L;
        Set<String> methods = Sets.newHashSet();
        Set<String> classes = Sets.newHashSet();

        TestResult() {
        }
    }
}

