/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.buildpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Bundle;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.buildpath.TestNGContainerInitializer;
import org.testng.eclipse.util.ResourceUtil;

public class BuildPathSupport {
    private static IPath getBundleLocation() {
        URL local;
        Bundle bundle = TestNGPlugin.getDefault().getBundle();
        if (bundle == null) {
            return null;
        }
        try {
            local = BuildPathSupport.getLocalURL(bundle.getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
        String fullPath = new File(local.getPath()).getAbsolutePath();
        return Path.fromOSString((String)fullPath);
    }

    private static URL getLocalURL(URL url) throws IOException {
        return Platform.asLocalURL((URL)url);
    }

    public static IClasspathEntry getTestNGClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)TestNGContainerInitializer.TESTNG_PATH);
    }

    public static IClasspathEntry getTestNGLibraryEntry() {
        IPath bundleBase = BuildPathSupport.getBundleLocation();
        if (bundleBase != null) {
            IPath jarLocation = bundleBase.append(ResourceUtil.getString("TestNG.jdk15.library"));
            IPath srcLocation = bundleBase.append(ResourceUtil.getString("TestNG.jdk15.sources"));
            return JavaCore.newLibraryEntry((IPath)jarLocation, (IPath)srcLocation, null);
        }
        return null;
    }

    public static boolean projectContainsClasspathEntry(IJavaProject project, IClasspathEntry entry) throws JavaModelException {
        IClasspathEntry[] oldEntries = project.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            if (oldEntries[i].equals(entry)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

