/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.core.commandhistory;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.springsource.ide.eclipse.commons.core.Entry;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

public class ValidProjectFilter
implements Iterable<Entry> {
    private final Iterable<Entry> target;
    private final String natureId;

    public ValidProjectFilter(Iterable<Entry> target, String natureId) {
        this.target = target;
        this.natureId = natureId;
    }

    @Override
    public Iterator<Entry> iterator() {
        IProject[] projects;
        final HashSet<String> validProjects = new HashSet<String>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && SpringCoreUtils.hasNature((IResource)project, this.natureId)) {
                validProjects.add(project.getName());
            }
            ++n2;
        }
        return new FilterIterator(this.target.iterator(), new Predicate(){

            public boolean evaluate(Object _entry) {
                Entry entry = (Entry)_entry;
                return validProjects.contains(entry.getProject());
            }
        });
    }
}

