/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.io.File;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.template.IWizardPageStatusHandler;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizardModel;
import org.springframework.ide.eclipse.wizard.template.WizardPageArea;

public class ProjectNameLocationArea
extends WizardPageArea {
    private final NameGroup nameGroup;
    private final LocationGroup locationGroup;
    private final Validator validator;
    private final Shell shell;
    private final NewSpringProjectWizardModel model;

    public ProjectNameLocationArea(NewSpringProjectWizardModel model, IWizardPageStatusHandler statusHandler, Shell shell) {
        super(statusHandler);
        this.shell = shell;
        this.model = model;
        this.validator = new Validator();
        this.nameGroup = new NameGroup();
        this.locationGroup = new LocationGroup();
    }

    public Control createArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        this.nameGroup.createControl(composite);
        this.locationGroup.createControl(composite);
        this.nameGroup.addObserver(this.locationGroup);
        this.nameGroup.notifyObservers();
        this.nameGroup.addObserver(this.validator);
        this.locationGroup.addObserver(this.validator);
        this.setProjectName("");
        return composite;
    }

    protected String getProjectName() {
        return this.nameGroup.getName();
    }

    protected void setProjectName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.nameGroup.setName(name);
    }

    protected IStatus validateArea() {
        int missingDataStatus = 1;
        String name = this.getProjectName();
        String location = this.locationGroup.getLocation().toOSString();
        this.model.projectName.setValue((Object)name);
        if (this.locationGroup.isUseDefaultSelected()) {
            this.model.projectLocation.setValue(null);
        } else {
            this.model.projectLocation.setValue((Object)location);
        }
        IWorkspace workspace = JavaPlugin.getWorkspace();
        if (name.length() == 0) {
            this.setAreaComplete(false);
            return this.createStatus(NewWizardMessages.NewJavaProjectWizardPageOne_Message_enterProjectName, missingDataStatus);
        }
        IStatus nameStatus = workspace.validateName(name, 4);
        if (!nameStatus.isOK()) {
            this.setAreaComplete(false);
            return this.createStatus(nameStatus.getMessage(), 4);
        }
        IProject handle = workspace.getRoot().getProject(name);
        if (handle.exists()) {
            this.setAreaComplete(false);
            return this.createStatus(NewWizardMessages.NewJavaProjectWizardPageOne_Message_projectAlreadyExists, 4);
        }
        IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(name);
        if (projectLocation.toFile().exists()) {
            try {
                String canonicalPath = projectLocation.toFile().getCanonicalPath();
                projectLocation = new Path(canonicalPath);
            }
            catch (IOException e) {
                WizardPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "I/O Error when correcting project path casing: " + e.getMessage(), (Throwable)e));
            }
            String existingName = projectLocation.lastSegment();
            if (!existingName.equals(this.nameGroup.getName())) {
                this.setAreaComplete(false);
                return this.createStatus(Messages.format((String)NewWizardMessages.NewJavaProjectWizardPageOne_Message_invalidProjectNameForWorkspaceRoot, (Object)BasicElementLabels.getResourceName((String)existingName)), 4);
            }
        }
        if (location.length() == 0) {
            this.setAreaComplete(false);
            return this.createStatus(NewWizardMessages.NewJavaProjectWizardPageOne_Message_enterLocation, missingDataStatus);
        }
        if (!Path.EMPTY.isValidPath(location)) {
            this.setAreaComplete(false);
            return this.createStatus(NewWizardMessages.NewJavaProjectWizardPageOne_Message_invalidDirectory, 4);
        }
        IPath projectPath = null;
        if (!(this.locationGroup.isUseDefaultSelected() || (projectPath = Path.fromOSString((String)location)).toFile().exists() || this.canCreate(projectPath.toFile()))) {
            this.setAreaComplete(false);
            return this.createStatus(NewWizardMessages.NewJavaProjectWizardPageOne_Message_cannotCreateAtExternalLocation, 4);
        }
        IStatus locationStatus = workspace.validateProjectLocation(handle, projectPath);
        if (!locationStatus.isOK()) {
            this.setAreaComplete(false);
            return this.createStatus(locationStatus.getMessage(), 4);
        }
        this.setAreaComplete(true);
        return Status.OK_STATUS;
    }

    private boolean canCreate(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        }
        return file.canWrite();
    }

    private final class LocationGroup
    extends Observable
    implements Observer,
    IStringButtonAdapter,
    IDialogFieldListener {
        protected final SelectionButtonDialogField fUseDefaults = new SelectionButtonDialogField(32);
        protected final StringButtonDialogField fLocation;
        private String fPreviousExternalLocation;
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";

        public LocationGroup() {
            this.fUseDefaults.setDialogFieldListener((IDialogFieldListener)this);
            this.fUseDefaults.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_location_desc);
            this.fLocation = new StringButtonDialogField((IStringButtonAdapter)this);
            this.fLocation.setDialogFieldListener((IDialogFieldListener)this);
            this.fLocation.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_locationLabel_desc);
            this.fLocation.setButtonLabel(NewWizardMessages.NewJavaProjectWizardPageOne_LocationGroup_browseButton_desc);
            this.fUseDefaults.setSelection(true);
            this.fPreviousExternalLocation = "";
        }

        public Control createControl(Composite composite) {
            Composite locationComposite = new Composite(composite, 0);
            locationComposite.setLayout((Layout)new GridLayout(4, false));
            this.fUseDefaults.doFillIntoGrid(locationComposite, 4);
            this.fLocation.doFillIntoGrid(locationComposite, 4);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLocation.getTextControl(null));
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)locationComposite);
            return locationComposite;
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        protected String getDefaultPath(String name) {
            IPath path = Platform.getLocation().append(name);
            return path.toOSString();
        }

        public void update(Observable o, Object arg) {
            if (this.isUseDefaultSelected()) {
                this.fLocation.setText(this.getDefaultPath(ProjectNameLocationArea.this.nameGroup.getName()));
            }
            this.fireEvent();
        }

        public IPath getLocation() {
            if (this.isUseDefaultSelected()) {
                return Platform.getLocation();
            }
            return Path.fromOSString((String)this.fLocation.getText().trim());
        }

        public boolean isUseDefaultSelected() {
            return this.fUseDefaults.isSelected();
        }

        public void setLocation(IPath path) {
            this.fUseDefaults.setSelection(path == null);
            if (path != null) {
                this.fLocation.setText(path.toOSString());
            } else {
                this.fLocation.setText(this.getDefaultPath(ProjectNameLocationArea.this.nameGroup.getName()));
            }
            this.fireEvent();
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(ProjectNameLocationArea.this.shell);
            dialog.setMessage(NewWizardMessages.NewJavaProjectWizardPageOne_directory_message);
            String directoryName = this.fLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                String oldDirectory = new Path(this.fLocation.getText().trim()).lastSegment();
                this.fLocation.setText(selectedDirectory);
                String lastSegment = new Path(selectedDirectory).lastSegment();
                if (lastSegment != null && (ProjectNameLocationArea.this.nameGroup.getName().length() == 0 || ProjectNameLocationArea.this.nameGroup.getName().equals(oldDirectory))) {
                    ProjectNameLocationArea.this.nameGroup.setName(lastSegment);
                }
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == this.fUseDefaults) {
                boolean checked = this.fUseDefaults.isSelected();
                if (checked) {
                    this.fPreviousExternalLocation = this.fLocation.getText();
                    this.fLocation.setText(this.getDefaultPath(ProjectNameLocationArea.this.nameGroup.getName()));
                    this.fLocation.setEnabled(false);
                } else {
                    this.fLocation.setText(this.fPreviousExternalLocation);
                    this.fLocation.setEnabled(true);
                }
            }
            this.fireEvent();
        }
    }

    protected final class NameGroup
    extends Observable
    implements IDialogFieldListener {
        protected final StringDialogField fNameField = new StringDialogField();

        public NameGroup() {
            this.fNameField.setLabelText(NewWizardMessages.NewJavaProjectWizardPageOne_NameGroup_label_text);
            this.fNameField.setDialogFieldListener((IDialogFieldListener)this);
        }

        public Control createControl(Composite composite) {
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setFont(composite.getFont());
            nameComposite.setLayout((Layout)new GridLayout(2, false));
            this.fNameField.doFillIntoGrid(nameComposite, 2);
            LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameComposite);
            return nameComposite;
        }

        protected void fireEvent() {
            this.setChanged();
            this.notifyObservers();
        }

        public String getName() {
            return this.fNameField.getText().trim();
        }

        public void postSetFocus() {
            this.fNameField.postSetFocusOnDialogField(ProjectNameLocationArea.this.shell.getDisplay());
        }

        public void setName(String name) {
            this.fNameField.setText(name);
        }

        public void dialogFieldChanged(DialogField field) {
            this.fireEvent();
        }
    }

    protected final class Validator
    implements Observer {
        protected Validator() {
        }

        public void update(Observable o, Object arg) {
            IStatus status = ProjectNameLocationArea.this.validateArea();
            ProjectNameLocationArea.this.notifyStatusChange(status);
        }
    }
}

