/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.importing;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.springframework.ide.eclipse.maven.MavenCorePlugin;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.CodeSet;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.ImportConfiguration;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.ImportStrategy;

public class MavenStrategy
extends ImportStrategy {
    public MavenStrategy() {
        Assert.isNotNull((Object)Platform.getBundle((String)"org.eclipse.m2e.core"), (String)"M2E is not installed");
    }

    public IRunnableWithProgress createOperation(ImportConfiguration conf) {
        return new MavenCodeSetImport(conf);
    }

    private static class MavenCodeSetImport
    implements IRunnableWithProgress {
        private final String projectName;
        private final File location;
        private final CodeSet codeset;

        public MavenCodeSetImport(ImportConfiguration conf) {
            this.projectName = conf.getProjectName();
            this.location = new File(conf.getLocation());
            this.codeset = conf.getCodeSet();
        }

        public void run(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
            mon.beginTask("Create maven project " + this.projectName, 4);
            try {
                try {
                    this.codeset.createAt(this.location);
                    mon.worked(1);
                    File pomFile = new File(this.location, "pom.xml");
                    Assert.isTrue((boolean)pomFile.isFile(), (String)("No pom file found: " + pomFile));
                    Assert.isTrue((pomFile.length() > 0L ? 1 : 0) != 0, (String)("Pom file contains no data: " + pomFile));
                    MavenCorePlugin.createEclipseProjectFromExistingMavenProject((File)pomFile, (IProgressMonitor)new SubProgressMonitor(mon, 3));
                }
                catch (InterruptedException e) {
                    throw e;
                }
                catch (InvocationTargetException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                mon.done();
            }
        }
    }
}

