/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.guides;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.ChooseOneSection;
import org.springframework.ide.eclipse.wizard.gettingstarted.guides.SelectionModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseOneSectionCombo<T>
extends ChooseOneSection {
    private final SelectionModel<T> selection;
    private final String label;
    private final T[] options;

    public ChooseOneSectionCombo(IPageWithSections owner, String label, SelectionModel<T> selection, T[] options) {
        super(owner);
        this.label = label;
        this.selection = selection;
        this.options = options;
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.selection.validator;
    }

    public void createContents(Composite page) {
        Composite field = new Composite(page, 0);
        GridLayout layout = GridLayoutFactory.fillDefaults().numColumns(2).create();
        field.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)field);
        Label fieldNameLabel = new Label(field, 0);
        fieldNameLabel.setText(this.label);
        GridDataFactory.fillDefaults().hint(80, -1).align(1, 0x1000000).applyTo((Control)fieldNameLabel);
        final Combo combo = new Combo(field, 8);
        combo.setItems(this.getLabels());
        Object preselect = this.selection.selection.getValue();
        if (preselect != null) {
            combo.setText(this.labelProvider.getText(preselect));
        }
        GridDataFactory.fillDefaults().applyTo((Control)combo);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int selected = combo.getSelectionIndex();
                if (selected >= 0) {
                    ((ChooseOneSectionCombo)ChooseOneSectionCombo.this).selection.selection.setValue(ChooseOneSectionCombo.this.options[selected]);
                } else {
                    ((ChooseOneSectionCombo)ChooseOneSectionCombo.this).selection.selection.setValue(null);
                }
            }
        });
    }

    private String[] getLabels() {
        String[] labels = new String[this.options.length];
        int i = 0;
        while (i < labels.length) {
            labels[i] = this.labelProvider.getText(this.options[i]);
            ++i;
        }
        return labels;
    }
}

