/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.boot;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.DomUtils;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.FieldArrayModel;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.MultiSelectionFieldModel;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.RadioGroup;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.RadioGroups;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.RadioInfo;
import org.springframework.ide.eclipse.wizard.gettingstarted.boot.UrlMaker;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.BuildType;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.CodeSet;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.ImportStrategy;
import org.springframework.ide.eclipse.wizard.gettingstarted.importing.ImportUtils;
import org.springsource.ide.eclipse.commons.core.preferences.StsProperties;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadableItem;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.URLConnectionFactory;
import org.springsource.ide.eclipse.commons.frameworks.core.util.XmlUtils;
import org.springsource.ide.eclipse.commons.livexp.core.FieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.StringFieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.validators.NewProjectLocationValidator;
import org.springsource.ide.eclipse.commons.livexp.core.validators.NewProjectNameValidator;
import org.springsource.ide.eclipse.commons.livexp.core.validators.UrlValidator;
import org.springsource.ide.eclipse.commons.livexp.ui.ProjectLocationSection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewSpringBootWizardModel {
    private static final Map<String, String> KNOWN_GROUP_LABELS = new HashMap<String, String>();
    private final URLConnectionFactory urlConnectionFactory;
    private final String FORM_URL;
    private String DOWNLOAD_URL;
    public final FieldArrayModel<String> stringInputs = new FieldArrayModel(new FieldModel[0]);
    public final MultiSelectionFieldModel<String> style = new MultiSelectionFieldModel<String>(String.class, "style").label("Style");
    private final FieldModel<String> projectName;
    private final LiveVariable<String> location;
    private final NewProjectLocationValidator locationValidator;
    private boolean allowUIThread = false;
    public final LiveVariable<String> baseUrl;
    public final LiveExpression<ValidationResult> baseUrlValidator;
    public final LiveVariable<String> downloadUrl = new LiveVariable();
    private IWorkingSet[] workingSets = new IWorkingSet[0];
    private RadioGroups radioGroups = new RadioGroups();

    static {
        KNOWN_GROUP_LABELS.put("type", "Type:");
        KNOWN_GROUP_LABELS.put("packaging", "Packaging:");
        KNOWN_GROUP_LABELS.put("javaVersion", "Java Version:");
        KNOWN_GROUP_LABELS.put("language", "Language:");
    }

    public NewSpringBootWizardModel() throws Exception {
        this(new URLConnectionFactory(), StsProperties.getInstance((IProgressMonitor)new NullProgressMonitor()));
    }

    public NewSpringBootWizardModel(URLConnectionFactory urlConnectionFactory, StsProperties stsProps) throws Exception {
        this(urlConnectionFactory, stsProps.get("spring.initializr.form.url"));
    }

    public NewSpringBootWizardModel(URLConnectionFactory urlConnectionFactory, String formUrl) throws Exception {
        this.urlConnectionFactory = urlConnectionFactory;
        this.FORM_URL = formUrl;
        this.discoverOptions(this.stringInputs, this.style);
        this.projectName = this.stringInputs.getField("name");
        this.projectName.validator((LiveExpression)new NewProjectNameValidator((LiveExpression)this.projectName.getVariable()));
        this.location = new LiveVariable((Object)ProjectLocationSection.getDefaultProjectLocation((String)((String)this.projectName.getValue())));
        this.locationValidator = new NewProjectLocationValidator("Location", this.location, (LiveExpression)this.projectName.getVariable());
        Assert.isNotNull(this.projectName, (String)("The form at " + this.FORM_URL + " doesn't have a 'name' text input"));
        this.baseUrl = new LiveVariable((Object)this.DOWNLOAD_URL);
        this.baseUrlValidator = new UrlValidator("Base Url", this.baseUrl);
        UrlMaker computedUrl = new UrlMaker((LiveExpression<String>)this.baseUrl);
        for (FieldModel<String> fieldModel : this.stringInputs) {
            computedUrl.addField(fieldModel);
        }
        computedUrl.addField(this.style);
        for (RadioGroup radioGroup : this.radioGroups.getGroups()) {
            computedUrl.addField(radioGroup);
        }
        computedUrl.addListener((ValueListener)new ValueListener<String>(){

            public void gotValue(LiveExpression<String> exp, String value) {
                NewSpringBootWizardModel.this.downloadUrl.setValue((Object)value);
            }
        });
        this.addBuildTypeValidator();
    }

    private void addBuildTypeValidator() {
        RadioGroup buildTypeGroup = this.getRadioGroups().getGroup("type");
        if (buildTypeGroup != null) {
            buildTypeGroup.validator(new Validator(){

                protected ValidationResult compute() {
                    BuildType bt = NewSpringBootWizardModel.this.getBuildType();
                    if (!bt.getImportStrategy().isSupported()) {
                        return ValidationResult.error((String)bt.getNotInstalledMessage());
                    }
                    return ValidationResult.OK;
                }
            }.dependsOn((LiveExpression)buildTypeGroup.getVariable()));
        }
    }

    public void performFinish(IProgressMonitor mon) throws InvocationTargetException, InterruptedException {
        mon.beginTask("Importing " + (String)this.baseUrl.getValue(), 4);
        DownloadManager downloader = null;
        try {
            try {
                downloader = new DownloadManager().allowUIThread(this.allowUIThread);
                DownloadableItem zip = new DownloadableItem(this.newURL((String)this.downloadUrl.getValue()), downloader);
                String projectNameValue = (String)this.projectName.getValue();
                CodeSet cs = CodeSet.fromZip(projectNameValue, zip, (IPath)new Path("/"));
                IRunnableWithProgress oper = this.getImportStrategy().createOperation(ImportUtils.importConfig((IPath)new Path((String)this.location.getValue()), projectNameValue, cs));
                oper.run((IProgressMonitor)new SubProgressMonitor(mon, 3));
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectNameValue);
                this.addToWorkingSets(project, (IProgressMonitor)new SubProgressMonitor(mon, 1));
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (downloader != null) {
                downloader.dispose();
            }
            mon.done();
        }
    }

    public ImportStrategy getImportStrategy() {
        return this.getBuildType().getImportStrategy();
    }

    public BuildType getBuildType() {
        RadioInfo selected;
        RadioGroup buildTypeRadios = this.getRadioGroups().getGroup("type");
        if (buildTypeRadios != null && (selected = (RadioInfo)buildTypeRadios.getSelection().selection.getValue()) != null) {
            if ("gradle.zip".equals(selected.getValue())) {
                return BuildType.GRADLE;
            }
            if ("starter.zip".equals(selected.getValue())) {
                return BuildType.MAVEN;
            }
            return BuildType.GENERAL;
        }
        return BuildType.MAVEN;
    }

    private void addToWorkingSets(IProject project, IProgressMonitor monitor) {
        monitor.beginTask("Add '" + project.getName() + "' to working sets", 1);
        try {
            if (this.workingSets == null || this.workingSets.length == 0) {
                return;
            }
            IWorkingSetManager wsm = PlatformUI.getWorkbench().getWorkingSetManager();
            wsm.addToWorkingSets((IAdaptable)project, this.workingSets);
        }
        finally {
            monitor.done();
        }
    }

    private void discoverOptions(FieldArrayModel<String> fields, MultiSelectionFieldModel<String> style) throws IOException, ParserConfigurationException, SAXException, URISyntaxException {
        URLConnection conn = null;
        InputStream input = null;
        try {
            URL url = new URL(this.FORM_URL);
            conn = this.urlConnectionFactory.createConnection(url);
            conn.connect();
            input = conn.getInputStream();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(input);
            NodeList forms = doc.getElementsByTagName("form");
            Assert.isLegal((forms.getLength() == 1 ? 1 : 0) != 0, (String)("Unexpected number of <form> elements at: " + this.FORM_URL));
            int i = 0;
            while (i < forms.getLength()) {
                Node form = forms.item(i);
                this.discoverDownloadUrl(form);
                ++i;
            }
            NodeList inputs = doc.getElementsByTagName("input");
            int i2 = 0;
            while (i2 < inputs.getLength()) {
                Node node = inputs.item(i2);
                if (this.isCheckbox(node)) {
                    this.discoverCheckboxOption(style, node);
                } else if (this.isStringInput(node)) {
                    this.discoverStringField(fields, node);
                } else if (this.isRadio(node)) {
                    this.disoverRadio(this.radioGroups, node);
                }
                ++i2;
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void disoverRadio(RadioGroups radioGroups, Node node) {
        String groupName = DomUtils.getAttributeValue(node, "name");
        String value = DomUtils.getAttributeValue(node, "value");
        boolean isChecked = DomUtils.getAttributeValue(node, "checked", false);
        RadioInfo radio = new RadioInfo(groupName, value, isChecked);
        RadioGroup group = radioGroups.ensureGroup(groupName);
        String groupLabel = this.getGroupLabel(groupName);
        if (groupLabel != null) {
            group.label(groupLabel);
            if (this.include(radio)) {
                String label = NewSpringBootWizardModel.getInputLabel(node);
                if (label != null) {
                    radio.setLabel(label);
                }
                group.add(radio);
            }
        }
    }

    protected boolean include(RadioInfo radio) {
        if ("type".equals(radio.getGroupName())) {
            String value = radio.getValue();
            return "gradle.zip".equals(value) || "starter.zip".equals(value);
        }
        return true;
    }

    private void discoverDownloadUrl(Node form) throws URISyntaxException {
        String action = DomUtils.getAttributeValue(form, "action");
        URI formUri = new URI(this.FORM_URL);
        this.DOWNLOAD_URL = formUri.resolve(action).toString();
    }

    public static String getInputLabel(Node input) {
        Node labelNode = NewSpringBootWizardModel.getParentLabel(input);
        if (labelNode == null) {
            labelNode = NewSpringBootWizardModel.getSiblingsLabel(input);
        }
        if (labelNode != null) {
            return NewSpringBootWizardModel.getLabelText(labelNode);
        }
        return null;
    }

    private static String getLabelText(Node labelNode) {
        if (labelNode != null) {
            NodeList children = labelNode.getChildNodes();
            StringBuilder text = new StringBuilder();
            int i = 0;
            while (i < children.getLength()) {
                Node sibling = children.item(i);
                if (sibling.getNodeType() == 3) {
                    text.append(sibling.getNodeValue().trim());
                }
                ++i;
            }
            String result = text.toString();
            while (result.endsWith(":")) {
                result = result.substring(0, result.length() - 1);
            }
            if (!"".equals(result)) {
                return result;
            }
        }
        return null;
    }

    protected String getGroupLabel(String groupName) {
        return KNOWN_GROUP_LABELS.get(groupName);
    }

    public static Node getParentLabel(Node input) {
        Node labelNode = input.getParentNode();
        if (labelNode != null && NewSpringBootWizardModel.isLabel(labelNode)) {
            return labelNode;
        }
        return null;
    }

    public static Node getSiblingsLabel(Node input) {
        while (input != null) {
            if (NewSpringBootWizardModel.isLabel(input)) {
                return input;
            }
            input = input.getPreviousSibling();
        }
        return null;
    }

    public static boolean isLabel(Node labelNode) {
        String tagName = XmlUtils.getTagName((Node)labelNode);
        return "label".equals(tagName);
    }

    private void discoverCheckboxOption(MultiSelectionFieldModel<String> style, Node checkbox) {
        String styleValue;
        String name = DomUtils.getAttributeValue(checkbox, "name");
        if (style.getName().equals(name) && (styleValue = DomUtils.getAttributeValue(checkbox, "value")) != null) {
            String styleLabel = NewSpringBootWizardModel.getInputLabel(checkbox);
            style.choice(styleLabel == null ? styleValue : styleLabel, styleValue);
        }
    }

    private void discoverStringField(FieldArrayModel<String> fields, Node node) {
        String name = DomUtils.getAttributeValue(node, "name");
        if (name != null) {
            String defaultValue = DomUtils.getAttributeValue(node, "value");
            StringFieldModel field = new StringFieldModel(name, defaultValue == null ? "" : defaultValue);
            String label = NewSpringBootWizardModel.getInputLabel(node);
            if (label != null) {
                field.label(label);
            }
            fields.add((FieldModel<String>)field);
        }
    }

    private boolean isCheckbox(Node node) {
        String type = DomUtils.getAttributeValue(node, "type");
        return "checkbox".equals(type);
    }

    private boolean isRadio(Node node) {
        String type = DomUtils.getAttributeValue(node, "type");
        return "radio".equals(type);
    }

    private boolean isStringInput(Node node) {
        String type = DomUtils.getAttributeValue(node, "type");
        return "text".equals(type);
    }

    private URL newURL(String value) {
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            WizardPlugin.log(e);
            return null;
        }
    }

    public void allowUIThread(boolean allow) {
        this.allowUIThread = allow;
    }

    public LiveExpression<ValidationResult> getLocationValidator() {
        return this.locationValidator;
    }

    public LiveVariable<String> getLocation() {
        return this.location;
    }

    public FieldModel<String> getProjectName() {
        return this.projectName;
    }

    public void setWorkingSets(IWorkingSet[] workingSets) {
        this.workingSets = workingSets;
    }

    public RadioGroups getRadioGroups() {
        return this.radioGroups;
    }
}

