/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.graph.parts.ActivityDiagramPart;
import org.springframework.ide.eclipse.config.graph.parts.GraphAnimation;
import org.springframework.ide.eclipse.config.graph.policies.TransitionEditPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    public TransitionPart(Transition model) {
        this.setModel(model);
    }

    public void activate() {
        super.activate();
        ((Transition)this.getModel()).addPropertyChangeListener(this);
    }

    protected void applyGraphResults(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        Edge e = (Edge)map.get(this);
        NodeList nodes = e.vNodes;
        PolylineConnection conn = (PolylineConnection)this.getConnectionFigure();
        if (nodes != null && !this.isManualLayout()) {
            ArrayList<AbsoluteBendpoint> bends = new ArrayList<AbsoluteBendpoint>();
            int i = 0;
            while (i < nodes.size()) {
                Node vn = nodes.getNode(i);
                int x = vn.x;
                int y = vn.y;
                if (e.isFeedback()) {
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                    bends.add(new AbsoluteBendpoint(x, y));
                } else {
                    bends.add(new AbsoluteBendpoint(x, y));
                    bends.add(new AbsoluteBendpoint(x, y + vn.height));
                }
                ++i;
            }
            conn.setRoutingConstraint(bends);
        } else {
            conn.setRoutingConstraint((Object)Collections.EMPTY_LIST);
        }
    }

    protected void contributeToGraph(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        GraphAnimation.recordInitialState(this.getConnectionFigure());
        Node source = (Node)map.get(this.getSource());
        Node target = (Node)map.get(this.getTarget());
        Edge e = new Edge((Object)this, source, target);
        graph.edges.add((Object)e);
        map.put((AbstractGraphicalEditPart)this, e);
    }

    protected void contributeNodesToGraph(CompoundDirectedGraph graph, Subgraph s, Map<AbstractGraphicalEditPart, Object> map) {
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new TransitionEditPolicy());
    }

    protected IFigure createFigure() {
        PolylineConnection conn = (PolylineConnection)super.createFigure();
        conn.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter(){

            public void route(Connection conn) {
                GraphAnimation.recordInitialState(conn);
                if (!GraphAnimation.playbackState(conn)) {
                    super.route(conn);
                }
            }
        });
        if (((Transition)this.getModel()).isDirectional()) {
            conn.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        }
        conn.setLineStyle(((Transition)this.getModel()).getLineStyle());
        conn.setForegroundColor(ColorConstants.gray);
        conn.setLineWidth(2);
        return conn;
    }

    public void deactivate() {
        super.deactivate();
        ((Transition)this.getModel()).removePropertyChangeListener(this);
    }

    public boolean isManualLayout() {
        EditPart part = this.getViewer().getContents();
        if (part instanceof ActivityDiagramPart) {
            ActivityDiagramPart diagramPart = (ActivityDiagramPart)part;
            return diagramPart.isManualLayout();
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if ("linestyle".equals(property)) {
            ((PolylineConnection)this.getFigure()).setLineStyle(((Transition)this.getModel()).getLineStyle());
        }
    }

    public void setSelected(int value) {
        super.setSelected(value);
        if (value != 0) {
            ((PolylineConnection)this.getFigure()).setLineWidth(3);
        } else {
            ((PolylineConnection)this.getFigure()).setLineWidth(2);
        }
    }
}

