/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.parts;

import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.jface.viewers.TextCellEditor;
import org.springframework.ide.eclipse.config.graph.figures.ParallelActivityFigure;
import org.springframework.ide.eclipse.config.graph.figures.SequentialActivityFigure;
import org.springframework.ide.eclipse.config.graph.figures.SubgraphFigure;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.StructuredActivity;
import org.springframework.ide.eclipse.config.graph.parts.ActivityCellEditorLocator;
import org.springframework.ide.eclipse.config.graph.parts.ActivityDirectEditManager;
import org.springframework.ide.eclipse.config.graph.parts.ActivityPart;
import org.springframework.ide.eclipse.config.graph.parts.GraphAnimation;
import org.springframework.ide.eclipse.config.graph.parts.TransitionPart;
import org.springframework.ide.eclipse.config.graph.policies.ActivityContainerHighlightEditPolicy;
import org.springframework.ide.eclipse.config.graph.policies.ActivityEditPolicy;
import org.springframework.ide.eclipse.config.graph.policies.ActivityNodeEditPolicy;
import org.springframework.ide.eclipse.config.graph.policies.StructuredActivityDirectEditPolicy;
import org.springframework.ide.eclipse.config.graph.policies.StructuredActivityLayoutEditPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StructuredActivityPart
extends ActivityPart
implements NodeEditPart {
    public StructuredActivityPart(StructuredActivity activity) {
        super(activity);
    }

    protected void applyChildrenResults(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        int i = 0;
        while (i < this.getChildren().size()) {
            ActivityPart part = (ActivityPart)this.getChildren().get(i);
            part.applyGraphResults(graph, map);
            ++i;
        }
    }

    @Override
    protected void applyGraphResults(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        this.applyOwnResults(graph, map);
        this.applyChildrenResults(graph, map);
    }

    protected void applyOwnResults(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        super.applyGraphResults(graph, map);
    }

    @Override
    protected void contributeNodesToGraph(CompoundDirectedGraph graph, Subgraph s, Map<AbstractGraphicalEditPart, Object> map) {
        GraphAnimation.recordInitialState(this.getContentPane());
        Subgraph me = new Subgraph((Object)this, s);
        me.outgoingOffset = 5;
        me.incomingOffset = 5;
        IFigure fig = this.getFigure();
        if (fig instanceof SubgraphFigure) {
            int tagHeight;
            if (graph.getDirection() == 16) {
                if (fig instanceof ParallelActivityFigure) {
                    me.width = fig.getPreferredSize((int)me.width, (int)me.height).width;
                    tagHeight = ((SubgraphFigure)fig).getHeader().getPreferredSize().height;
                    int tagWidth = ((SubgraphFigure)fig).getHeader().getPreferredSize().width;
                    me.insets.left = tagHeight;
                    me.insets.top = tagWidth;
                    me.insets.right = tagHeight;
                } else if (fig instanceof SequentialActivityFigure) {
                    int tagWidth;
                    me.height = fig.getPreferredSize((int)me.width, (int)me.height).height;
                    me.insets.top = tagWidth = ((SubgraphFigure)fig).getHeader().getPreferredSize().width;
                    me.insets.left = 0;
                    me.insets.bottom = tagWidth;
                }
            } else {
                me.width = fig.getPreferredSize((int)me.width, (int)me.height).width;
                me.insets.top = tagHeight = ((SubgraphFigure)fig).getHeader().getPreferredSize().height;
                me.insets.left = 0;
                me.insets.bottom = tagHeight;
            }
        }
        me.innerPadding = new Insets(0);
        if (graph.getDirection() == 16) {
            me.setPadding(new Insets(6, 8, 6, 8));
        } else {
            me.setPadding(new Insets(8, 6, 8, 6));
        }
        map.put(this, me);
        graph.nodes.add((Object)me);
        int i = 0;
        while (i < this.getChildren().size()) {
            ActivityPart activity = (ActivityPart)this.getChildren().get(i);
            activity.contributeNodesToGraph(graph, me, map);
            ++i;
        }
        i = 0;
        while (i < this.getSourceConnections().size()) {
            TransitionPart trans = (TransitionPart)this.getSourceConnections().get(i);
            Subgraph cfr_ignored_0 = (Subgraph)map.get(this.getViewer().getContents());
            trans.contributeNodesToGraph(graph, s, map);
            ++i;
        }
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ActivityEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new StructuredActivityDirectEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActivityNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new StructuredActivityLayoutEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ActivityContainerHighlightEditPolicy());
    }

    private boolean directEditHitTest(Point requestLoc) {
        IFigure header = ((SubgraphFigure)this.getFigure()).getHeader();
        header.translateToRelative((Translatable)requestLoc);
        return header.containsPoint(requestLoc);
    }

    @Override
    protected int getAnchorOffset() {
        return -1;
    }

    public IFigure getContentPane() {
        if (this.getFigure() instanceof SubgraphFigure) {
            return ((SubgraphFigure)this.getFigure()).getContents();
        }
        return this.getFigure();
    }

    protected List<Activity> getModelChildren() {
        return this.getStructuredActivity().getChildren();
    }

    StructuredActivity getStructuredActivity() {
        return (StructuredActivity)this.getModel();
    }

    @Override
    protected void performDirectEdit() {
        if (this.manager == null) {
            Label l = (Label)((SubgraphFigure)this.getFigure()).getHeader();
            this.manager = new ActivityDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new ActivityCellEditorLocator(l), l);
        }
        this.manager.show();
    }

    @Override
    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            if (request instanceof DirectEditRequest && !this.directEditHitTest(((DirectEditRequest)request).getLocation().getCopy())) {
                return;
            }
            this.performDirectEdit();
        } else if (request.getType() == "open") {
            this.performOpen();
        }
    }

    @Override
    protected void refreshFigureVisuals() {
        ((Label)((SubgraphFigure)this.getFigure()).getHeader()).setText(this.getActivity().getName());
        ((Label)((SubgraphFigure)this.getFigure()).getFooter()).setText("/" + this.getActivity().getName());
    }
}

