/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.parts;

import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.springframework.ide.eclipse.config.graph.ConfigGraphCommonImages;
import org.springframework.ide.eclipse.config.graph.figures.SimpleActivityLabel;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.parts.ActivityCellEditorLocator;
import org.springframework.ide.eclipse.config.graph.parts.ActivityDiagramPart;
import org.springframework.ide.eclipse.config.graph.parts.ActivityDirectEditManager;
import org.springframework.ide.eclipse.config.graph.parts.ActivityPart;
import org.springframework.ide.eclipse.config.graph.parts.TransitionPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleActivityPart
extends ActivityPart {
    public SimpleActivityPart(Activity activity) {
        super(activity);
    }

    @Override
    protected void contributeNodesToGraph(CompoundDirectedGraph graph, Subgraph s, Map<AbstractGraphicalEditPart, Object> map) {
        Node n = new Node((Object)this, s);
        n.setRowConstraint(this.getActivity().getSortIndex());
        n.outgoingOffset = this.getAnchorOffset();
        n.incomingOffset = this.getAnchorOffset();
        Dimension hint = this.getFigureHint();
        n.width = hint.width;
        n.height = hint.height;
        if (graph.getDirection() == 16) {
            n.setPadding(new Insets(8, 10, 12, 10));
        } else {
            n.setPadding(new Insets(10, 8, 10, 12));
        }
        map.put(this, n);
        graph.nodes.add((Object)n);
        int i = 0;
        while (i < this.getSourceConnections().size()) {
            TransitionPart trans = (TransitionPart)this.getSourceConnections().get(i);
            Subgraph cfr_ignored_0 = (Subgraph)map.get(this.getViewer().getContents());
            trans.contributeNodesToGraph(graph, s, map);
            ++i;
        }
    }

    protected IFigure createFigure() {
        int direction = 4;
        EditPart part = this.getViewer().getContents();
        if (part instanceof ActivityDiagramPart) {
            ActivityDiagramPart diagramPart = (ActivityDiagramPart)part;
            direction = diagramPart.getDirection();
        }
        SimpleActivityLabel l = new SimpleActivityLabel(direction);
        l.setIcon(CommonImages.getImage((ImageDescriptor)ConfigGraphCommonImages.ACTIVITY));
        return l;
    }

    @Override
    protected int getAnchorOffset() {
        EditPart part = this.getViewer().getContents();
        if (part instanceof ActivityDiagramPart) {
            ActivityDiagramPart diagramPart = (ActivityDiagramPart)part;
            IFigure figure = this.getFigure();
            int direction = diagramPart.getDirection();
            if (direction != 16 && figure instanceof Label) {
                return ((Label)figure).getIconBounds().width / 2;
            }
        }
        return -1;
    }

    protected Dimension getFigureHint() {
        return this.getFigure().getPreferredSize();
    }

    @Override
    protected void performDirectEdit() {
        if (this.manager == null) {
            Label l = (Label)this.getFigure();
            this.manager = new ActivityDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new ActivityCellEditorLocator(l), l);
        }
        this.manager.show();
    }

    @Override
    protected void refreshFigureVisuals() {
        ((Label)this.getFigure()).setText(this.getActivity().getName());
    }
}

