/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.parts;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.springframework.ide.eclipse.config.graph.figures.BorderedContainerFigure;
import org.springframework.ide.eclipse.config.graph.figures.SubgraphFigure;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.StructuredActivity;
import org.springframework.ide.eclipse.config.graph.parts.ActivityDiagramPart;
import org.springframework.ide.eclipse.config.graph.parts.ActivityPart;
import org.springframework.ide.eclipse.config.graph.parts.GraphAnimation;
import org.springframework.ide.eclipse.config.graph.parts.StructuredActivityPart;
import org.springframework.ide.eclipse.config.graph.parts.TransitionPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BorderedContainerPart
extends StructuredActivityPart
implements ActionListener {
    public BorderedContainerPart(StructuredActivity activity) {
        super(activity);
    }

    public void actionPerformed(ActionEvent event) {
        this.refreshAll();
    }

    @Override
    protected void applyChildrenResults(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        SubgraphFigure figure = (SubgraphFigure)this.getFigure();
        int headerY = figure.getHeader().getBounds().getBottom().y + 8;
        int y = 0;
        int x = -1;
        int heightSum = 0;
        int i = 0;
        while (i < this.getChildren().size()) {
            ActivityPart part = (ActivityPart)this.getChildren().get(i);
            part.applyGraphResults(graph, map);
            Point p = part.getFigure().getBounds().getLocation();
            if (x == -1) {
                x = p.x;
            }
            p.y = y = headerY + heightSum;
            p.x = x;
            part.getFigure().setLocation(p);
            heightSum += part.getFigure().getBounds().height + 5;
            ++i;
        }
        this.applyMaxWidths();
    }

    protected void applyChildrenResultsToOwn(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        Node n = (Node)map.get(this);
        int bottom = -1;
        int i = 0;
        while (i < this.getChildren().size()) {
            ActivityPart part = (ActivityPart)this.getChildren().get(i);
            if (part.getFigure().getBounds().bottom() > bottom) {
                bottom = part.getFigure().getBounds().getBottom().y;
            }
            ++i;
        }
        if (bottom > -1) {
            int top = this.getFigure().getBounds().getTop().y;
            int height = bottom - top + 14;
            this.getFigure().setBounds(new Rectangle(n.x, n.y, n.width, height));
        }
    }

    @Override
    protected void applyGraphResults(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        super.applyGraphResults(graph, map);
        this.applyChildrenResultsToOwn(graph, map);
    }

    protected void applyMaxWidths() {
        Rectangle rect;
        ActivityPart part;
        int maxWidth = 0;
        int i = 0;
        while (i < this.getChildren().size()) {
            part = (ActivityPart)this.getChildren().get(i);
            rect = part.getFigure().getBounds();
            if (rect.width >= maxWidth) {
                maxWidth = rect.width;
            }
            ++i;
        }
        i = 0;
        while (i < this.getChildren().size()) {
            part = (ActivityPart)this.getChildren().get(i);
            rect = part.getFigure().getBounds();
            rect.width = maxWidth;
            part.getFigure().setBounds(rect);
            ++i;
        }
    }

    @Override
    public void contributeEdgesToGraph(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        PropertyChangeListener part;
        List outgoing = this.getSourceConnections();
        int i = 0;
        while (i < outgoing.size()) {
            part = (TransitionPart)this.getSourceConnections().get(i);
            part.contributeToGraph(graph, map);
            ++i;
        }
        i = 0;
        while (i < this.getChildren().size()) {
            part = (ActivityPart)this.getChildren().get(i);
            if (i + 1 < this.getChildren().size()) {
                Edge e = new Edge((Node)map.get(part), (Node)map.get(this.getChildren().get(i + 1)));
                e.weight = 1;
                graph.edges.add((Object)e);
            }
            ++i;
        }
    }

    @Override
    public void contributeNodesToGraph(CompoundDirectedGraph graph, Subgraph s, Map<AbstractGraphicalEditPart, Object> map) {
        GraphAnimation.recordInitialState(this.getContentPane());
        Subgraph me = new Subgraph((Object)this, s);
        me.outgoingOffset = 5;
        me.incomingOffset = 5;
        IFigure fig = this.getFigure();
        if (fig instanceof SubgraphFigure) {
            me.width = fig.getPreferredSize((int)me.width, (int)me.height).width;
            me.height = fig.getPreferredSize().height;
            me.insets.top = ((SubgraphFigure)this.getFigure()).getHeader().getPreferredSize().height + 5;
            me.insets.left = 5;
            me.insets.right = 5;
            me.insets.bottom = 15;
        }
        me.innerPadding = new Insets(0, 0, 6, 4);
        map.put(this, me);
        graph.nodes.add((Object)me);
        int i = 0;
        while (i < this.getChildren().size()) {
            ActivityPart activity = (ActivityPart)this.getChildren().get(i);
            activity.contributeNodesToGraph(graph, me, map);
            ++i;
        }
    }

    protected IFigure createFigure() {
        int direction = 4;
        EditPart part = this.getViewer().getContents();
        if (part instanceof ActivityDiagramPart) {
            ActivityDiagramPart diagramPart = (ActivityDiagramPart)part;
            direction = diagramPart.getDirection();
        }
        BorderedContainerFigure figure = new BorderedContainerFigure(this.createHeaderFigure(direction), direction);
        figure.addActionListener(this);
        return figure;
    }

    protected abstract Label createHeaderFigure(int var1);

    @Override
    protected List<Activity> getModelChildren() {
        BorderedContainerFigure figure = (BorderedContainerFigure)this.getFigure();
        if (figure.isExpanded()) {
            return super.getModelChildren();
        }
        return new ArrayList<Activity>();
    }

    @Override
    protected void refreshVisuals() {
        ((Label)((SubgraphFigure)this.getFigure()).getHeader()).setText(this.getActivity().getName());
    }
}

