/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GroupBoxBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class ConnectorBorder
extends GroupBoxBorder {
    protected final int direction;
    protected PointList connector;
    protected PointList bottomConnector;
    protected final int inputCapacity;
    protected final int outputCapacity;

    public ConnectorBorder(int direction, int inputs, int outputs) {
        super("");
        this.direction = direction;
        this.inputCapacity = inputs;
        this.outputCapacity = outputs;
        this.createPointLists();
        if (direction == 16) {
            this.connector.transpose();
            this.bottomConnector.transpose();
        }
    }

    private void createPointLists() {
        this.connector = new PointList();
        this.bottomConnector = new PointList();
        this.connector.addPoint(-3, 0);
        this.connector.addPoint(-3, 6);
        this.connector.addPoint(3, 6);
        this.connector.addPoint(3, 0);
        this.bottomConnector.addPoint(3, 0);
        this.bottomConnector.addPoint(3, -6);
        this.bottomConnector.addPoint(-3, -6);
        this.bottomConnector.addPoint(-3, 0);
    }

    protected void drawAnchors(Graphics graphics, Rectangle rect) {
        graphics.pushState();
        graphics.setBackgroundColor(ColorConstants.gray);
        graphics.setForegroundColor(ColorConstants.gray);
        if (this.direction == 16) {
            int y1;
            int x1 = rect.x;
            int end = rect.width + x1;
            int height = rect.height;
            int i = 0;
            while (i < this.inputCapacity) {
                y1 = rect.y + (2 * i + 1) * height / (this.inputCapacity * 2);
                this.connector.translate(x1, y1);
                graphics.fillPolygon(this.connector);
                graphics.drawPolygon(this.connector);
                this.connector.translate(-x1, -y1);
                ++i;
            }
            i = 0;
            while (i < this.outputCapacity) {
                y1 = rect.y + (2 * i + 1) * height / (this.outputCapacity * 2);
                this.bottomConnector.translate(end, y1);
                graphics.fillPolygon(this.bottomConnector);
                graphics.drawPolygon(this.bottomConnector);
                this.bottomConnector.translate(-end, -y1);
                ++i;
            }
        } else {
            int x1;
            int y1 = rect.y;
            int width = rect.width;
            int bottom = y1 + rect.height;
            int i = 0;
            while (i < this.inputCapacity) {
                x1 = rect.x + (2 * i + 1) * width / (this.inputCapacity * 2);
                this.connector.translate(x1, y1);
                graphics.fillPolygon(this.connector);
                graphics.drawPolygon(this.connector);
                this.connector.translate(-x1, -y1);
                ++i;
            }
            i = 0;
            while (i < this.outputCapacity) {
                x1 = rect.x + (2 * i + 1) * width / (this.outputCapacity * 2);
                this.bottomConnector.translate(x1, bottom);
                graphics.fillPolygon(this.bottomConnector);
                graphics.drawPolygon(this.bottomConnector);
                this.bottomConnector.translate(-x1, -bottom);
                ++i;
            }
        }
        graphics.popState();
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        this.drawAnchors(graphics, figure.getBounds().getCropped(insets));
        this.superPaint(figure, graphics, insets);
    }

    private void paintEtchedBorder(Graphics g, Rectangle r) {
        Color rgb = ColorConstants.gray;
        Color shadow = FigureUtilities.darker((Color)rgb);
        Color highlight = FigureUtilities.lighter((Color)rgb);
        this.paintEtchedBorder(g, r, shadow, highlight);
        shadow.dispose();
        highlight.dispose();
    }

    private void paintEtchedBorder(Graphics g, Rectangle r, Color shadow, Color highlight) {
        int x = r.x;
        int y = r.y;
        int w = r.width;
        int h = r.height;
        int arc = 10;
        g.setLineStyle(1);
        g.setLineWidth(1);
        g.setXORMode(false);
        g.setForegroundColor(shadow);
        g.drawRoundRectangle(new Rectangle(x, y, w -= 2, h -= 2), arc, arc);
        g.setForegroundColor(highlight);
        g.drawRoundRectangle(new Rectangle(++x, ++y, w, h), arc, arc);
    }

    private void superPaint(IFigure figure, Graphics g, Insets insets) {
        tempRect.setBounds(ConnectorBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        Rectangle r = tempRect;
        if (r.isEmpty()) {
            return;
        }
        Rectangle textLoc = new Rectangle(r.getTopLeft(), this.getTextExtents(figure));
        r.crop(new Insets(this.getTextExtents((IFigure)figure).height / 2));
        this.paintEtchedBorder(g, r);
        textLoc.x += this.getInsets((IFigure)figure).left;
        g.setFont(this.getFont(figure));
        g.setForegroundColor(this.getTextColor());
        g.clipRect(textLoc);
        g.fillText(this.getLabel(), textLoc.getTopLeft());
    }
}

