/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.springframework.ide.eclipse.config.core.IConfigEditor;
import org.springframework.ide.eclipse.config.core.IConfigEditorPage;
import org.springframework.ide.eclipse.config.core.contentassist.SpringConfigContentAssistProcessor;
import org.springframework.ide.eclipse.config.core.extensions.PageAdaptersExtensionPointConstants;
import org.springframework.ide.eclipse.config.graph.SpringConfigGraphOutlinePage;
import org.springframework.ide.eclipse.config.graph.actions.ExportAction;
import org.springframework.ide.eclipse.config.graph.actions.ResetManualLayoutAction;
import org.springframework.ide.eclipse.config.graph.actions.ShowPropertiesAction;
import org.springframework.ide.eclipse.config.graph.actions.ShowSourceAction;
import org.springframework.ide.eclipse.config.graph.actions.SpringConfigContextMenuProvider;
import org.springframework.ide.eclipse.config.graph.model.AbstractConfigGraphDiagram;
import org.springframework.ide.eclipse.config.graph.parts.AbstractConfigEditPartFactory;
import org.springframework.ide.eclipse.config.graph.parts.AbstractConfigPaletteFactory;
import org.springframework.ide.eclipse.config.graph.parts.ActivityDiagramPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigGraphicalEditor
extends GraphicalEditorWithPalette
implements IConfigEditorPage {
    public static String PAGE_KIND = "graphicalEditor";
    private IConfigEditor editor;
    private IContentOutlinePage contentOutline;
    private AbstractConfigGraphDiagram diagram;
    private PaletteRoot root;
    private KeyHandler keyHandler;
    private String namespaceUri;
    private AbstractConfigPaletteFactory paletteFactory;
    private final Set<IConfigurationElement> adapterDefinitions = new HashSet<IConfigurationElement>();
    private TemplateTransferDragSourceListener transferSourceListener;
    private TemplateTransferDropTargetListener transferTargetListener;

    public AbstractConfigGraphicalEditor() {
    }

    public AbstractConfigGraphicalEditor(IConfigEditor editor, String uri) {
        this();
        this.initialize(editor, uri);
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScalableFreeformRootEditPart rootEditPart = new ScalableFreeformRootEditPart();
        this.getGraphicalViewer().setRootEditPart((RootEditPart)rootEditPart);
        ArrayList<String> zoomLevels = new ArrayList<String>();
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        rootEditPart.getZoomManager().setZoomLevelContributions(zoomLevels);
        ZoomInAction zoomIn = new ZoomInAction(rootEditPart.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(rootEditPart.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)this.createEditPartFactory());
        this.getGraphicalViewer().setKeyHandler(new GraphicalViewerKeyHandler(this.getGraphicalViewer()).setParent(this.getCommonKeyHandler()));
        ContextMenuProvider provider = this.createContextMenuProvider();
        this.getGraphicalViewer().setContextMenu((MenuManager)provider);
        this.getEditorSite().registerContextMenu((MenuManager)provider, (ISelectionProvider)this.getGraphicalViewer(), false);
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        Object action = new DirectEditAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new PrintAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new ExportAction(this);
        registry.registerAction((IAction)action);
        action = new ShowPropertiesAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ShowSourceAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ResetManualLayoutAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    protected ContextMenuProvider createContextMenuProvider() {
        return new SpringConfigContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry());
    }

    protected abstract AbstractConfigEditPartFactory createEditPartFactory();

    protected abstract AbstractConfigGraphDiagram createFlowDiagram();

    public byte[] createImage(int format) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Display device = this.getGraphicalViewer().getControl().getDisplay();
        LayerManager lm = (LayerManager)this.getGraphicalViewer().getEditPartRegistry().get(LayerManager.ID);
        IFigure figure = lm.getLayer((Object)"Printable Layers");
        Rectangle r = figure.getClientArea();
        Image image = null;
        GC gc = null;
        SWTGraphics g = null;
        try {
            image = new Image((Device)device, r.width, r.height);
            gc = new GC((Drawable)image);
            g = new SWTGraphics(gc);
            g.translate(r.x * -1, r.y * -1);
            figure.paint((Graphics)g);
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{image.getImageData()};
            imageLoader.save((OutputStream)result, format);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
        return result.toByteArray();
    }

    protected abstract AbstractConfigPaletteFactory createPaletteFactory();

    protected PaletteRoot createPaletteRoot() {
        this.paletteFactory = this.createPaletteFactory();
        return this.paletteFactory.getPaletteRoot();
    }

    public void dispose() {
        if (this.transferSourceListener != null) {
            this.getPaletteViewer().removeDragSourceListener((TransferDragSourceListener)this.transferSourceListener);
        }
        if (this.transferTargetListener != null) {
            this.getGraphicalViewer().removeDropTargetListener((TransferDropTargetListener)this.transferTargetListener);
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.getCommandStack().markSaveLocation();
        this.diagram.doSaveCoordinates();
    }

    public void doSaveAs() {
        this.getCommandStack().markSaveLocation();
        this.setInput(this.editor.getEditorInput());
        this.modelUpdated();
        this.diagram.doSaveCoordinates();
    }

    public Object getAdapter(Class type) {
        if (IContentOutlinePage.class == type) {
            return this.getContentOutline();
        }
        if (ActionRegistry.class == type) {
            return this.getActionRegistry();
        }
        if (CommandStack.class == type) {
            return this.getEditDomain().getCommandStack();
        }
        if (ZoomManager.class == type) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        if (ISelectionProvider.class == type) {
            return this.getGraphicalViewer();
        }
        return super.getAdapter(type);
    }

    public Set<IConfigurationElement> getAdapterDefinitions() {
        return this.adapterDefinitions;
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.keyHandler.put(KeyStroke.getReleased((char)'\b', (int)8, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.keyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.keyHandler;
    }

    private IContentOutlinePage getContentOutline() {
        RootEditPart rootEditPart;
        if (this.contentOutline == null && this.getGraphicalViewer() != null && (rootEditPart = this.getGraphicalViewer().getRootEditPart()) instanceof ScalableFreeformRootEditPart) {
            this.contentOutline = new SpringConfigGraphOutlinePage((ScalableFreeformRootEditPart)rootEditPart);
        }
        return this.contentOutline;
    }

    public AbstractConfigGraphDiagram getDiagram() {
        return this.diagram;
    }

    public IDOMDocument getDomDocument() {
        return this.editor.getDomDocument();
    }

    public IConfigEditor getEditor() {
        return this.editor;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getPageKind() {
        return PAGE_KIND;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = this.createPaletteRoot();
        }
        return this.root;
    }

    public IFile getResourceFile() {
        return this.editor.getResourceFile();
    }

    public SpringConfigContentAssistProcessor getXmlProcessor() {
        return this.getEditor().getXmlProcessor();
    }

    private void initAdapterDefinitions() {
        Set allAdapters = this.editor.getAdapterDefinitions();
        for (IConfigurationElement config : allAdapters) {
            String parent = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_PARENT_URI);
            String uri = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_NAMESPACE_URI);
            String label = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_LABEL);
            String partFactory = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_EDITPART_FACTORY);
            String modelFactory = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_MODEL_FACTORY);
            String paletteFactory = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_PALETTE_FACTORY);
            if (parent == null || !parent.equals(this.namespaceUri) || uri == null || partFactory == null || modelFactory == null || label == null || paletteFactory == null) continue;
            this.adapterDefinitions.add(config);
        }
    }

    public void initialize(IConfigEditor editor, String uri) {
        this.editor = editor;
        this.namespaceUri = uri;
        this.initAdapterDefinitions();
        this.diagram = this.createFlowDiagram();
        DefaultEditDomain defaultEditDomain = new DefaultEditDomain((IEditorPart)this);
        this.setEditDomain(defaultEditDomain);
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.diagram);
        this.transferTargetListener = new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer());
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)this.transferTargetListener);
    }

    protected void initializePaletteViewer() {
        super.initializePaletteViewer();
        this.transferSourceListener = new TemplateTransferDragSourceListener((EditPartViewer)this.getPaletteViewer());
        this.getPaletteViewer().addDragSourceListener((TransferDragSourceListener)this.transferSourceListener);
    }

    public void modelUpdated() {
        ActivityDiagramPart part = (ActivityDiagramPart)this.getGraphicalViewer().getContents();
        if (part != null && part.isActive()) {
            part.refreshAll();
        }
    }

    public void namespacesUpdated() {
        if (this.paletteFactory != null) {
            this.paletteFactory.updatePalette();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.editor.getActiveEditor())) {
            this.updateActions(this.getSelectionActions());
        }
    }
}

