/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.io.File;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.misc.TermInfoWiTFQueue;
import org.apache.lucene.misc.TermStats;
import org.apache.lucene.misc.TotalTermFreqComparatorSortDescending;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class HighFreqTerms {
    public static final int DEFAULTnumTerms = 100;
    public static int numTerms = 100;

    public static void main(String[] args) throws Exception {
        IndexReader reader = null;
        FSDirectory dir = null;
        String field = null;
        boolean IncludeTermFreqs = false;
        if (args.length == 0 || args.length > 4) {
            HighFreqTerms.usage();
            System.exit(1);
        }
        if (args.length > 0) {
            dir = FSDirectory.open((File)new File(args[0]));
        }
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("-t")) {
                IncludeTermFreqs = true;
                continue;
            }
            try {
                numTerms = Integer.parseInt(args[i]);
                continue;
            }
            catch (NumberFormatException e) {
                field = args[i];
            }
        }
        reader = IndexReader.open((Directory)dir, (boolean)true);
        TermStats[] terms = HighFreqTerms.getHighFreqTerms(reader, numTerms, field);
        if (!IncludeTermFreqs) {
            for (int i = 0; i < terms.length; ++i) {
                System.out.printf("%s %,d \n", terms[i].term, terms[i].docFreq);
            }
        } else {
            TermStats[] termsWithTF = HighFreqTerms.sortByTotalTermFreq(reader, terms);
            for (int i = 0; i < termsWithTF.length; ++i) {
                System.out.printf("%s \t total_tf = %,d \t doc freq = %,d \n", termsWithTF[i].term, termsWithTF[i].totalTermFreq, termsWithTF[i].docFreq);
            }
        }
        reader.close();
    }

    private static void usage() {
        System.out.println("\n\njava org.apache.lucene.misc.HighFreqTerms <index dir> [-t] [number_terms] [field]\n\t -t: include totalTermFreq\n\n");
    }

    public static TermStats[] getHighFreqTerms(IndexReader reader, int numTerms, String field) throws Exception {
        TermEnum terms;
        TermInfoWiTFQueue tiq = new TermInfoWiTFQueue(numTerms);
        if (field != null) {
            terms = reader.terms(new Term(field));
            if (terms != null && terms.term() != null) {
                while (terms.term().field().equals(field)) {
                    tiq.insertWithOverflow(new TermStats(terms.term(), terms.docFreq()));
                    if (terms.next()) continue;
                    break;
                }
            } else {
                System.out.println("No terms for field \"" + field + "\"");
            }
        } else {
            terms = reader.terms();
            while (terms.next()) {
                tiq.insertWithOverflow(new TermStats(terms.term(), terms.docFreq()));
            }
        }
        TermStats[] result = new TermStats[tiq.size()];
        int count = tiq.size() - 1;
        while (tiq.size() != 0) {
            result[count] = (TermStats)tiq.pop();
            --count;
        }
        return result;
    }

    public static TermStats[] sortByTotalTermFreq(IndexReader reader, TermStats[] terms) throws Exception {
        TermStats[] ts = new TermStats[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            long totalTF = HighFreqTerms.getTotalTermFreq(reader, terms[i].term);
            ts[i] = new TermStats(terms[i].term, terms[i].docFreq, totalTF);
        }
        TotalTermFreqComparatorSortDescending c = new TotalTermFreqComparatorSortDescending();
        Arrays.sort(ts, c);
        return ts;
    }

    public static long getTotalTermFreq(IndexReader reader, Term term) throws Exception {
        long totalTF = 0L;
        TermDocs td = reader.termDocs(term);
        while (td.next()) {
            totalTF += (long)td.freq();
        }
        return totalTF;
    }
}

