/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.validator.helper;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.BeansValidationContext;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.quickfix.BeansEditorValidator;
import org.springframework.ide.eclipse.quickfix.processors.QuickfixProcessorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansValidationContextHelper
extends BeansValidationContext {
    private final IProject project;
    private final AttrImpl attribute;
    private final IReporter reporter;
    private final BeansEditorValidator validator;
    private final IDOMNode node;
    private final QuickfixProcessorFactory quickfixFactory;
    private final boolean affectsWholeBean;
    private final boolean reportError;
    private boolean errorFound;
    private final Set<String> problemIdToIgnore;

    public BeansValidationContextHelper(AttrImpl attribute, IDOMNode node, IResourceModelElement rootElement, IProject project, IReporter reporter, BeansEditorValidator validator, QuickfixProcessorFactory quickfixFactory, boolean affectsWholeBean, boolean reportError, IBeansConfig config) {
        this(attribute, node, rootElement, project, reporter, validator, quickfixFactory, affectsWholeBean, reportError, config, null);
    }

    public BeansValidationContextHelper(AttrImpl attribute, IDOMNode node, IResourceModelElement rootElement, IProject project, IReporter reporter, BeansEditorValidator validator, QuickfixProcessorFactory quickfixFactory, boolean affectsWholeBean, boolean reportError, IBeansConfig config, Set<String> problemIdToIgnore) {
        super(config, rootElement);
        this.attribute = attribute;
        this.node = node;
        this.project = project;
        this.reporter = reporter;
        this.validator = validator;
        this.quickfixFactory = quickfixFactory;
        this.affectsWholeBean = affectsWholeBean;
        this.reportError = reportError;
        this.problemIdToIgnore = problemIdToIgnore;
        new HashMap();
        this.errorFound = false;
    }

    public void error(IResourceModelElement element, String problemId, String message, ValidationProblemAttribute ... attributes) {
        if (this.problemIdToIgnore != null && this.problemIdToIgnore.contains(problemId)) {
            return;
        }
        int severity = this.getSeverity(problemId, 1);
        if (this.reportError && severity >= 0) {
            if (this.affectsWholeBean) {
                this.validator.createAndAddMessageForNode(this.node, this.node, this.attribute.getValue(), message, this.reporter, this.quickfixFactory, severity, problemId, attributes);
            } else {
                this.validator.createAndAddMessage(this.attribute.getValueRegion(), this.node, message, this.reporter, this.quickfixFactory, this.affectsWholeBean, severity, problemId, attributes);
            }
        }
        this.errorFound = true;
        super.error(element, problemId, message, attributes);
    }

    public boolean getErrorFound() {
        return this.errorFound;
    }

    public IProject getRootElementProject() {
        return this.project;
    }

    protected int getSeverity(String messageId, int defaultSeverity) {
        switch (defaultSeverity) {
            case 1: {
                defaultSeverity = 2;
                break;
            }
            case 2: {
                defaultSeverity = 1;
                break;
            }
            case 4: {
                defaultSeverity = 0;
            }
        }
        int severity = super.getSeverity(messageId, defaultSeverity);
        switch (severity) {
            case 2: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 4;
            }
        }
        return -1;
    }

    public void info(IResourceModelElement element, String problemId, String message, ValidationProblemAttribute ... attributes) {
        if (this.problemIdToIgnore != null && this.problemIdToIgnore.contains(problemId)) {
            return;
        }
        int severity = this.getSeverity(problemId, 4);
        if (this.reportError && severity >= 0) {
            this.validator.createAndAddMessage(this.attribute.getValueRegion(), this.node, message, this.reporter, this.quickfixFactory, this.affectsWholeBean, severity, problemId, attributes);
        }
        super.info(element, problemId, message, attributes);
    }

    public void warning(IResourceModelElement element, String problemId, String message, ValidationProblemAttribute ... attributes) {
        if (this.problemIdToIgnore != null && this.problemIdToIgnore.contains(problemId)) {
            return;
        }
        int severity = this.getSeverity(problemId, 2);
        if (this.reportError && severity >= 0) {
            this.validator.createAndAddMessage(this.attribute.getValueRegion(), this.node, message, this.reporter, this.quickfixFactory, this.affectsWholeBean, severity, problemId, attributes);
        }
        this.errorFound = true;
        super.warning(element, problemId, message, attributes);
    }
}

