/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RemoveConstructorArgQuickFixProposal
extends BeanAttributeQuickFixProposal {
    private final int numAdditionalParams;
    private final IDOMNode beanNode;
    private final String label;

    public RemoveConstructorArgQuickFixProposal(int offset, int length, boolean missingEndQuote, int numAdditionalParams, IDOMNode beanNode, String label) {
        super(offset, length, missingEndQuote);
        this.numAdditionalParams = numAdditionalParams;
        this.beanNode = beanNode;
        this.label = label;
    }

    public void applyQuickFix(IDocument document) {
        IStructuredModel model = null;
        try {
            if (document instanceof IStructuredDocument) {
                model = StructuredModelManager.getModelManager().getModelForEdit((IStructuredDocument)document);
                model.beginRecording((Object)this);
            }
            NodeList childNodes = this.beanNode.getChildNodes();
            int numRemoved = 0;
            int i = childNodes.getLength() - 1;
            while (i >= 0) {
                Node child = childNodes.item(i);
                String nodeName = child.getNodeName();
                if (nodeName != null && nodeName.equals(BeansSchemaConstants.ELEM_CONSTRUCTOR_ARG)) {
                    this.beanNode.removeChild(child);
                    if (++numRemoved >= this.numAdditionalParams) break;
                }
                --i;
            }
            new FormatProcessorXML().formatNode((Node)this.beanNode);
        }
        finally {
            if (model != null) {
                model.endRecording((Object)this);
                model.releaseFromEdit();
                model = null;
            }
        }
    }

    public String getDisplayString() {
        return this.label;
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.remove_correction.gif");
    }
}

