/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateConstructorQuickFixProposal
extends BeanAttributeQuickFixProposal {
    private final IJavaProject javaProject;
    private final String className;
    private final List<String> constructorArgClassNames;

    public CreateConstructorQuickFixProposal(int offset, int length, String text, boolean missingEndQuote, IJavaProject javaProject, List<String> constructorArgClassNames) {
        super(offset, length, missingEndQuote);
        this.javaProject = javaProject;
        this.className = text;
        this.constructorArgClassNames = constructorArgClassNames;
    }

    @Override
    public void applyQuickFix(IDocument document) {
        try {
            IType type = this.javaProject.findType(this.className);
            if (type != null) {
                QuickfixUtils.createConstructor(document, type, this.constructorArgClassNames, this.javaProject);
            }
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)e.getStatus());
        }
    }

    public String getDisplayString() {
        String shortClassName = this.className;
        int pos = this.className.lastIndexOf(".");
        if (pos > 0) {
            shortClassName = this.className.substring(pos + 1);
        }
        String args = "";
        int i = 0;
        while (i < this.constructorArgClassNames.size()) {
            if (i > 0) {
                args = String.valueOf(args) + ", ";
            }
            args = String.valueOf(args) + "Object";
            ++i;
        }
        return "Create constructor " + shortClassName + "(" + args + ")";
    }

    public Image getImage() {
        return BeansUIImages.getImage((String)"org.springframework.ide.eclipse.beans.ui.constructor_obj.gif");
    }
}

