/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.processors.BeanQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.proposals.AddConstructorArgQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.AddConstructorParamQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.CreateConstructorQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.RemoveConstructorArgQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.RemoveConstructorParamQuickFixProposal;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorArgQuickAssistProcessor
extends BeanQuickAssistProcessor {
    private final List<String> constructorArgClassNames;
    private final IJavaProject javaProject;
    private final String className;
    private final JavaElementLabelProvider labelProvider;
    private final IDOMNode beanNode;

    public ConstructorArgQuickAssistProcessor(int offset, int length, String text, IProject project, boolean missingEndQuote, List<String> constructorArgClassNames, IDOMNode beanNode) {
        super(offset, length, text, missingEndQuote);
        this.className = text;
        this.constructorArgClassNames = constructorArgClassNames;
        this.beanNode = beanNode;
        this.javaProject = JavaCore.create((IProject)project);
        this.labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        try {
            IMethod[] methods;
            IType type = this.javaProject.findType(this.className);
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.isConstructor()) {
                    proposals.addAll(this.createProposalForConstructor(method));
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)e.getStatus());
        }
        proposals.add(new CreateConstructorQuickFixProposal(this.offset, this.length, this.className, this.missingEndQuote, this.javaProject, this.constructorArgClassNames));
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private List<ICompletionProposal> createProposalForConstructor(IMethod method) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        int diff = method.getNumberOfParameters() - this.constructorArgClassNames.size();
        if (diff > 0) {
            proposals.addAll(this.createProposalForMoreParameters(method, diff));
        } else if (diff < 0) {
            proposals.addAll(this.createProposalForLessParameters(method, diff * -1));
        }
        return proposals;
    }

    private List<ICompletionProposal> createProposalForLessParameters(IMethod constructor, int numAdditionalParams) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String label = "Remove <constructor-arg> to match " + this.getConstructorDisplay(constructor);
        proposals.add(new RemoveConstructorArgQuickFixProposal(this.offset, this.length, this.missingEndQuote, numAdditionalParams, this.beanNode, label));
        label = "Change constructor " + this.getConstructorDisplay(constructor);
        proposals.add(new AddConstructorParamQuickFixProposal(this.offset, this.length, this.missingEndQuote, numAdditionalParams, constructor, label, this.javaProject));
        return proposals;
    }

    private List<ICompletionProposal> createProposalForMoreParameters(IMethod constructor, int numAdditionalArgs) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String label = "Add <constructor-arg> to match " + this.getConstructorDisplay(constructor);
        proposals.add(new AddConstructorArgQuickFixProposal(this.offset, this.length, this.missingEndQuote, numAdditionalArgs, this.beanNode, label));
        IMethodBinding methodBinding = QuickfixUtils.getMethodBinding(this.javaProject, constructor);
        if (methodBinding != null) {
            label = "Change constructor " + this.getConstructorDisplay(constructor);
            proposals.add(new RemoveConstructorParamQuickFixProposal(this.offset, this.length, this.missingEndQuote, numAdditionalArgs, constructor, label, this.javaProject));
        }
        return proposals;
    }

    private String getConstructorDisplay(IMethod constructor) {
        return "'" + this.labelProvider.getText((Object)constructor) + "'";
    }
}

