/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.processors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.quickfix.ContentAssistProposalWrapper;
import org.springframework.ide.eclipse.quickfix.QuickfixContentAssistConverter;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.processors.BeanQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.proposals.AddConfigSetQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.AddToConfigSetQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.CreateImportQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.CreateNewBeanQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.RenameToSimilarNameQuickFixProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanReferenceQuickAssistProcessor
extends BeanQuickAssistProcessor {
    private final IDOMNode node;
    private final IFile file;
    private final String attributeName;
    private final String beanName;

    public static List<ICompletionProposal> computeBeanReferenceQuickAssistProposals(IDOMNode node, String attributeName, IFile file, String text, String beanName, int offset, int length, boolean missingEndQuote) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Set<ContentAssistProposalWrapper> possibleProposals = new QuickfixContentAssistConverter(node, attributeName, file).getReferenceableBeanDescriptions(text, false);
        for (ContentAssistProposalWrapper proposal : possibleProposals) {
            proposals.add(new RenameToSimilarNameQuickFixProposal(proposal.getName(), offset, length, missingEndQuote, proposal.getDisplayText()));
        }
        IDOMNode beanNode = QuickfixUtils.getEnclosingBeanNode(node);
        if (beanNode != null) {
            proposals.add(new CreateNewBeanQuickFixProposal(offset, length, missingEndQuote, text, beanNode));
        } else {
            proposals.add(new CreateNewBeanQuickFixProposal(offset, length, missingEndQuote, text, node));
        }
        IBeansModel model = BeansCorePlugin.getModel();
        BeansProject project = (BeansProject)model.getProject(file.getProject());
        if (project != null) {
            HashSet<IResource> foundResources = new HashSet<IResource>();
            ArrayList<CreateImportQuickFixProposal> importProposals = new ArrayList<CreateImportQuickFixProposal>();
            ArrayList<AddToConfigSetQuickFixProposal> addToConfigSetProposals = new ArrayList<AddToConfigSetQuickFixProposal>();
            ArrayList<AddConfigSetQuickFixProposal> addConfigSetProposals = new ArrayList<AddConfigSetQuickFixProposal>();
            Set configs = project.getConfigs();
            for (IBeansConfig config : configs) {
                IBean bean = config.getBean(beanName);
                if (bean == null) continue;
                importProposals.add(new CreateImportQuickFixProposal(offset, length, missingEndQuote, bean, beanNode, (IBeansProject)project, file));
                Set configSets = project.getConfigSets();
                for (IBeansConfigSet configSet : configSets) {
                    if (!configSet.hasConfig((IFile)bean.getElementResource())) continue;
                    addToConfigSetProposals.add(new AddToConfigSetQuickFixProposal(offset, length, missingEndQuote, file, configSet, project));
                }
                addConfigSetProposals.add(new AddConfigSetQuickFixProposal(offset, length, missingEndQuote, bean, file));
                foundResources.add(bean.getElementResource());
            }
            proposals.addAll(importProposals);
            proposals.addAll(addToConfigSetProposals);
            proposals.addAll(addConfigSetProposals);
        }
        return proposals;
    }

    public BeanReferenceQuickAssistProcessor(int offset, int length, String text, boolean missingEndQuote, IDOMNode node, String attributeName, String beanName, IFile file) {
        super(offset, length, text, missingEndQuote);
        this.node = node;
        this.attributeName = attributeName;
        this.beanName = beanName;
        this.file = file;
    }

    public BeanReferenceQuickAssistProcessor(String beanName, IFile file) {
        super(0, 0, beanName, false);
        this.node = null;
        this.attributeName = null;
        this.beanName = beanName;
        this.file = file;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        List<ICompletionProposal> proposals = BeanReferenceQuickAssistProcessor.computeBeanReferenceQuickAssistProposals(this.node, this.attributeName, this.file, this.text, this.beanName, this.offset, this.length, this.missingEndQuote);
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }
}

