/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AnnotationCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

public class AddAutowireCompletionProposal
extends AnnotationCompletionProposal {
    private final BodyDeclaration decl;
    private final Param[] params;

    public AddAutowireCompletionProposal(BodyDeclaration decl, ICompilationUnit cu, Param ... params) {
        super(AddAutowireCompletionProposal.getDisplayName(params), cu, QuickfixImages.getImage(QuickfixImages.ANNOTATION));
        this.decl = decl;
        this.params = params;
    }

    private Annotation createAnnotation(String qualifiedName, String simpleName, CompilationUnit astRoot, AST ast, ASTRewrite astRewrite, ImportRewrite importRewrite, boolean memberValuePair, ASTNode precedingNode) {
        if (!ProposalCalculatorUtil.containsImport(this.getCompilationUnit(), qualifiedName)) {
            importRewrite.addImport(qualifiedName);
        }
        Object annotation = memberValuePair ? ast.newNormalAnnotation() : ast.newMarkerAnnotation();
        annotation.setTypeName((Name)ast.newSimpleName(simpleName));
        ChildListPropertyDescriptor property = this.decl instanceof FieldDeclaration ? FieldDeclaration.MODIFIERS2_PROPERTY : MethodDeclaration.MODIFIERS2_PROPERTY;
        if (precedingNode != null) {
            astRewrite.getListRewrite((ASTNode)this.decl, property).insertBefore((ASTNode)annotation, precedingNode, null);
        } else {
            astRewrite.getListRewrite((ASTNode)this.decl, property).insertFirst((ASTNode)annotation, null);
        }
        return annotation;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.decl);
        ASTRewrite astRewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRewrite.getAST();
        ImportRewrite importRewrite = this.createImportRewrite(astRoot);
        if (this.params.length == 0) {
            this.createAnnotation(Autowired.class.getCanonicalName(), Autowired.class.getSimpleName(), astRoot, ast, astRewrite, importRewrite, false, null);
        } else {
            NormalAnnotation autowiredAnnotation = (NormalAnnotation)this.createAnnotation(Autowired.class.getCanonicalName(), Autowired.class.getSimpleName(), astRoot, ast, astRewrite, importRewrite, true, null);
            int i = 0;
            while (i < this.params.length) {
                switch (this.params[i]) {
                    case REQUIRED: {
                        MemberValuePair requiredValue = ast.newMemberValuePair();
                        requiredValue.setName(ast.newSimpleName("required"));
                        requiredValue.setValue((Expression)ast.newBooleanLiteral(false));
                        this.addLinkedPosition(astRewrite.track((ASTNode)requiredValue.getValue()), i == 0, "Autowire");
                        autowiredAnnotation.values().add(requiredValue);
                    }
                }
                ++i;
            }
        }
        return astRewrite;
    }

    private static String getDisplayName(Param[] params) {
        StringBuffer buf = new StringBuffer();
        buf.append("Add @Autowired");
        if (params.length > 0) {
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(AddAutowireCompletionProposal.getParamName(params[i]));
                ++i;
            }
        }
        return buf.toString();
    }

    private static String getParamName(Param param) {
        switch (param) {
            case REQUIRED: {
                return "(required=false)";
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Param {
        REQUIRED,
        QUALIFIER;

    }
}

