/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.processors.AbstractAnnotationQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AddPathVariableCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AddPathVariableParameterCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springframework.ide.eclipse.quickfix.jdt.util.UriTemplateVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathVariableAnnotationQuickAssistProcessor
extends AbstractAnnotationQuickAssistProcessor {
    private Map<UriTemplateVariable, List<SingleVariableDeclaration>> variableToMissingAnnotationParams;
    private Map<UriTemplateVariable, List<SingleVariableDeclaration>> variableToParams;

    @Override
    public String getAnnotationName() {
        return "PathVariable";
    }

    private MethodDeclaration getMethodDeclaration(ASTNode node) {
        if (node == null || node instanceof MethodDeclaration) {
            return (MethodDeclaration)node;
        }
        return this.getMethodDeclaration(node.getParent());
    }

    private void findParametersWithMissingAnnotation(List<UriTemplateVariable> variables, List<SingleVariableDeclaration> params, IProject project) {
        for (SingleVariableDeclaration param : params) {
            String variableName = ProposalCalculatorUtil.getPathVariableName(param);
            for (UriTemplateVariable variable : variables) {
                if (ProposalCalculatorUtil.isKnownRequestMappingParamType(project, param.getType().resolveBinding())) continue;
                if (variableName == null) {
                    this.variableToMissingAnnotationParams.get(variable).add(param);
                    continue;
                }
                if (!variableName.equals(variable.getVariableName()) || this.isRegEx(variableName)) continue;
                this.variableToParams.get(variable).add(param);
            }
        }
    }

    @Override
    public boolean isQuickfixAvailable(MethodDeclaration methodDecl, IInvocationContext context) {
        Set<Annotation> annotations = ProposalCalculatorUtil.findAnnotations("RequestMapping", (ASTNode)methodDecl);
        ArrayList<UriTemplateVariable> variables = new ArrayList<UriTemplateVariable>();
        for (Annotation annotation : annotations) {
            variables.addAll(ProposalCalculatorUtil.getUriTemplatVariables(annotation));
        }
        if (variables.size() > 0) {
            for (UriTemplateVariable variable : variables) {
                String variableName = variable.getVariableName();
                if (this.isRegEx(variableName)) continue;
                this.variableToMissingAnnotationParams.put(variable, new ArrayList());
                this.variableToParams.put(variable, new ArrayList());
            }
            List params = methodDecl.parameters();
            this.findParametersWithMissingAnnotation(variables, params, context.getCompilationUnit().getResource().getProject());
        }
        for (UriTemplateVariable variable : this.variableToParams.keySet()) {
            if (!this.variableToParams.get(variable).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isRegEx(String variableName) {
        return Pattern.matches(".*\\W.*", variableName);
    }

    @Override
    public boolean isQuickfixAvailable(TypeDeclaration typeDecl, IInvocationContext context) {
        Set<Annotation> annotations = ProposalCalculatorUtil.findAnnotations("RequestMapping", (ASTNode)typeDecl);
        ArrayList<UriTemplateVariable> variables = new ArrayList<UriTemplateVariable>();
        for (Annotation annotation : annotations) {
            variables.addAll(ProposalCalculatorUtil.getUriTemplatVariables(annotation));
        }
        for (UriTemplateVariable variable : variables) {
            this.variableToMissingAnnotationParams.put(variable, new ArrayList());
            this.variableToParams.put(variable, new ArrayList());
        }
        if (variables.size() > 0) {
            MethodDeclaration[] methodDecls;
            MethodDeclaration[] methodDeclarationArray = methodDecls = typeDecl.getMethods();
            int n = methodDecls.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDeclaration methodDecl = methodDeclarationArray[n2];
                this.findParametersWithMissingAnnotation(variables, methodDecl.parameters(), context.getCompilationUnit().getResource().getProject());
                ++n2;
            }
        }
        return this.variableToMissingAnnotationParams.keySet().size() > 0;
    }

    @Override
    protected void setUpFields() {
        this.variableToMissingAnnotationParams = new HashMap<UriTemplateVariable, List<SingleVariableDeclaration>>();
        this.variableToParams = new HashMap<UriTemplateVariable, List<SingleVariableDeclaration>>();
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForMethod(MethodDeclaration methodDecl, SimpleName name, ICompilationUnit cu) {
        return this.getAssists((BodyDeclaration)methodDecl, cu);
    }

    private List<IJavaCompletionProposal> getAssists(BodyDeclaration decl, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        ArrayList<SingleVariableDeclaration> includedParams = new ArrayList<SingleVariableDeclaration>();
        for (UriTemplateVariable variable : this.variableToMissingAnnotationParams.keySet()) {
            List<SingleVariableDeclaration> missingAnnotationsParams = this.variableToMissingAnnotationParams.get(variable);
            for (SingleVariableDeclaration param : missingAnnotationsParams) {
                proposals.add((IJavaCompletionProposal)new AddPathVariableCompletionProposal(variable, param, this.getMethodDeclaration((ASTNode)param), cu, decl instanceof TypeDeclaration));
                includedParams.add(param);
            }
            if (!missingAnnotationsParams.isEmpty() || !(decl instanceof MethodDeclaration) || !this.variableToParams.get(variable).isEmpty()) continue;
            proposals.add((IJavaCompletionProposal)new AddPathVariableParameterCompletionProposal(variable, (MethodDeclaration)decl, cu));
        }
        return proposals;
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForType(TypeDeclaration typeDecl, SimpleName name, ICompilationUnit cu) {
        return this.getAssists((BodyDeclaration)typeDecl, cu);
    }
}

