/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.processors.AbstractAnnotationQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.RemoveQualifierCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.SetAutowireRequiredFalseCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutowireRequiredNotFoundAnnotationQuickAssistProcessor
extends AbstractAnnotationQuickAssistProcessor {
    private List<MemberValuePair> valuePairs;
    private List<Annotation> autowiredAnnotations;
    private List<Annotation> qualifierAnnotations;

    @Override
    public String getAnnotationName() {
        return "Autowired";
    }

    @Override
    protected void setUpFields() {
        this.valuePairs = new ArrayList<MemberValuePair>();
        this.autowiredAnnotations = new ArrayList<Annotation>();
        this.qualifierAnnotations = new ArrayList<Annotation>();
    }

    @Override
    public boolean isQuickfixAvailable(FieldDeclaration fieldDecl, IInvocationContext context) {
        if (this.isRequired((BodyDeclaration)fieldDecl)) {
            this.findAnnotationRequiredToRemove((BodyDeclaration)fieldDecl, context);
            this.findQualifierToRemove((ASTNode)fieldDecl, fieldDecl.getType(), context);
            return this.autowiredAnnotations.size() > 0 || this.qualifierAnnotations.size() > 0;
        }
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(MethodDeclaration methodDecl, IInvocationContext context) {
        if (this.isRequired((BodyDeclaration)methodDecl)) {
            this.findAnnotationRequiredToRemove((BodyDeclaration)methodDecl, context);
            List params = methodDecl.parameters();
            for (SingleVariableDeclaration param : params) {
                this.findQualifierToRemove((ASTNode)param, param.getType(), context);
            }
            return this.autowiredAnnotations.size() > 0 || this.qualifierAnnotations.size() > 0;
        }
        return false;
    }

    private boolean isRequired(BodyDeclaration decl) {
        Set<Annotation> annotations = ProposalCalculatorUtil.findAnnotations("Autowired", (ASTNode)decl);
        Iterator<Annotation> iterator = annotations.iterator();
        if (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            if (annotation instanceof NormalAnnotation) {
                List values = ((NormalAnnotation)annotation).values();
                for (MemberValuePair pair : values) {
                    if (!"required".equals(pair.getName().getFullyQualifiedName())) continue;
                    Expression expression = pair.getValue();
                    return expression instanceof BooleanLiteral && ((BooleanLiteral)expression).booleanValue();
                }
            }
            return true;
        }
        return false;
    }

    private void findAnnotationRequiredToRemove(BodyDeclaration decl, IInvocationContext context) {
        Set<Annotation> annotations = ProposalCalculatorUtil.findAnnotations("Autowired", (ASTNode)decl);
        MemberValuePair valuePair = ProposalCalculatorUtil.getRequiredMemberValuePair(decl);
        if (valuePair != null) {
            if (valuePair.getValue() instanceof BooleanLiteral && ((BooleanLiteral)valuePair.getValue()).booleanValue()) {
                this.valuePairs.add(valuePair);
            }
        } else if (annotations.size() > 0) {
            annotations.addAll(annotations);
        }
    }

    private void findQualifierToRemove(ASTNode node, Type type, IInvocationContext context) {
        Set<Annotation> annotations = ProposalCalculatorUtil.findAnnotations("Qualifier", node);
        for (Annotation annotation : annotations) {
            Expression expression;
            if (!(annotation instanceof SingleMemberAnnotation) || !((expression = ((SingleMemberAnnotation)annotation).getValue()) instanceof StringLiteral)) continue;
            String qualifier = ((StringLiteral)expression).getLiteralValue();
            ITypeBinding typeBinding = type.resolveBinding();
            Set<String> beans = ProposalCalculatorUtil.getMatchingBeans(context, typeBinding, qualifier);
            if (!beans.isEmpty()) continue;
            this.qualifierAnnotations.add(annotation);
        }
    }

    private List<IJavaCompletionProposal> getAssists(ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        for (Annotation annotation : this.autowiredAnnotations) {
            proposals.add((IJavaCompletionProposal)new SetAutowireRequiredFalseCompletionProposal(annotation, cu));
        }
        for (MemberValuePair valuePair : this.valuePairs) {
            proposals.add((IJavaCompletionProposal)new SetAutowireRequiredFalseCompletionProposal(valuePair, cu));
        }
        for (Annotation annotation : this.qualifierAnnotations) {
            proposals.add((IJavaCompletionProposal)new RemoveQualifierCompletionProposal(annotation, cu));
        }
        return proposals;
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForField(FieldDeclaration fieldDecl, SimpleName name, ICompilationUnit cu) {
        return this.getAssists(cu);
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForMethod(MethodDeclaration methodDecl, SimpleName name, ICompilationUnit cu) {
        return this.getAssists(cu);
    }
}

