/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.processors.AbstractAnnotationQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AddAutowiredConstructorCompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAutowireConstructorQuickAssistProcessor
extends AbstractAnnotationQuickAssistProcessor {
    private ITypeBinding typeBinding;

    @Override
    public String getAnnotationName() {
        return "Autowired";
    }

    @Override
    public boolean isQuickfixAvailable(FieldDeclaration fieldDecl, IInvocationContext context) {
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(MethodDeclaration methodDecl, IInvocationContext context) {
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(SingleVariableDeclaration param, IInvocationContext context) {
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(TypeDeclaration typeDecl, IInvocationContext context) {
        CompilationUnit astRoot = context.getASTRoot();
        this.typeBinding = ASTNodes.getTypeBinding((Name)typeDecl.getName());
        if (this.typeBinding == null) {
            return false;
        }
        if (this.typeBinding.isAnnotation()) {
            return false;
        }
        if (this.typeBinding.isEnum()) {
            return false;
        }
        List<IVariableBinding> finalVariablesList = this.computeFinalVariables(astRoot);
        if (finalVariablesList.size() == 0) {
            return false;
        }
        return !this.hasNonDefaultConstructor(typeDecl);
    }

    private boolean hasNonDefaultConstructor(TypeDeclaration typeDecl) {
        MethodDeclaration[] methodDeclarationArray = typeDecl.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDecl = methodDeclarationArray[n2];
            if (methodDecl.isConstructor() && methodDecl.parameters().size() != 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private List<IVariableBinding> computeFinalVariables(CompilationUnit astRoot) {
        ArrayList<IVariableBinding> variables = new ArrayList<IVariableBinding>();
        IVariableBinding[] iVariableBindingArray = this.typeBinding.getDeclaredFields();
        int n = iVariableBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode declaringNode;
            IVariableBinding varBinding = iVariableBindingArray[n2];
            if (!(varBinding.isSynthetic() || Modifier.isStatic((int)varBinding.getModifiers()) || !Modifier.isFinal((int)varBinding.getModifiers()) || (declaringNode = astRoot.findDeclaringNode((IBinding)varBinding)) instanceof VariableDeclarationFragment && ((VariableDeclarationFragment)declaringNode).getInitializer() != null)) {
                variables.add(varBinding);
            }
            ++n2;
        }
        return variables;
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForType(TypeDeclaration typeDecl, SimpleName name, ICompilationUnit icu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        CompilationUnit cu = ASTResolving.findParentCompilationUnit((ASTNode)typeDecl);
        List<IVariableBinding> variables = this.computeFinalVariables(cu);
        IVariableBinding[] finalVariables = new IVariableBinding[variables.size()];
        finalVariables = variables.toArray(finalVariables);
        AddAutowiredConstructorCompletionProposal proposal = new AddAutowiredConstructorCompletionProposal(typeDecl, icu, finalVariables);
        proposals.add((IJavaCompletionProposal)proposal);
        return proposals;
    }
}

