/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.springframework.ide.eclipse.quickfix.jdt.processors.AutowireRequiredNotFoundAnnotationQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.processors.QualifierAnnotationQuickAssistProcessor;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public class AutowireMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (this.hasResolutions(marker)) {
            String problemType = marker.getAttribute("AUTOWIRE_PROBLEM", null);
            String handle = marker.getAttribute("JAVA_HANDLE", null);
            IJavaElement javaElement = JavaCore.create((String)handle);
            try {
                if (javaElement instanceof IMember) {
                    List fragments;
                    MethodDeclaration decl;
                    ISourceRange sourceRange;
                    ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
                    IMember member = (IMember)javaElement;
                    ICompilationUnit compilationUnit = member.getCompilationUnit();
                    AssistContext assistContext = new AssistContext(compilationUnit, null, (sourceRange = member.getSourceRange()).getOffset(), sourceRange.getLength());
                    ASTNode node = assistContext.getCoveringNode();
                    if (node instanceof MethodDeclaration) {
                        decl = (MethodDeclaration)node;
                        if (problemType.equals("TOO_MANY_MATCHING_BEANS")) {
                            proposals.addAll(new QualifierAnnotationQuickAssistProcessor().getAssists((ASTNode)decl, (IInvocationContext)assistContext));
                        } else if (problemType.equals("REQUIRED_NO_MATCH")) {
                            proposals.addAll(new AutowireRequiredNotFoundAnnotationQuickAssistProcessor().getAssists((ASTNode)decl, (IInvocationContext)assistContext));
                        }
                    } else if (node instanceof FieldDeclaration && (fragments = (decl = (FieldDeclaration)node).fragments()).size() > 0) {
                        if (problemType.equals("TOO_MANY_MATCHING_BEANS")) {
                            proposals.addAll(new QualifierAnnotationQuickAssistProcessor().getAssists((ASTNode)decl, (IInvocationContext)assistContext));
                        } else if (problemType.equals("REQUIRED_NO_MATCH")) {
                            proposals.addAll(new AutowireRequiredNotFoundAnnotationQuickAssistProcessor().getAssists((ASTNode)decl, (IInvocationContext)assistContext));
                        }
                    }
                    ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>();
                    for (IJavaCompletionProposal proposal : proposals) {
                        if (!(proposal instanceof IMarkerResolution)) continue;
                        resolutions.add((IMarkerResolution)proposal);
                    }
                    return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
                }
            }
            catch (JavaModelException e) {
                StatusHandler.log((IStatus)e.getStatus());
            }
        }
        return new IMarkerResolution[0];
    }

    public boolean hasResolutions(IMarker marker) {
        String problemType = marker.getAttribute("AUTOWIRE_PROBLEM", null);
        String handle = marker.getAttribute("JAVA_HANDLE", null);
        return problemType != null && handle != null;
    }
}

