/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.hyperlinks;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;

public class AutowireBeanHyperlink
implements IHyperlink {
    private final IFile file;
    private final int line;
    private final String beanName;
    private boolean onlyCandidate;
    private boolean showFileName;

    public AutowireBeanHyperlink(IFile file, int line, String beanName) {
        this.file = file;
        this.line = line;
        this.beanName = beanName;
        this.onlyCandidate = false;
        this.showFileName = false;
    }

    public IFile getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setIsOnlyCandidate(boolean onlyCandidate) {
        this.onlyCandidate = onlyCandidate;
    }

    public void open() {
        SpringUIUtils.openInEditor((IFile)this.file, (int)this.line);
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        if (this.onlyCandidate) {
            return "Open Autowired Bean";
        }
        if (!this.showFileName) {
            return "Open Autowired Bean Candidate: \"" + this.beanName + "\"";
        }
        return "Open Autowired Bean Candidate: \"" + this.beanName + "\"" + " in " + this.file.getName();
    }

    public IRegion getHyperlinkRegion() {
        return new IRegion(){

            public int getOffset() {
                return 0;
            }

            public int getLength() {
                return 0;
            }
        };
    }

    public void setShowFileName(boolean showFileName) {
        this.showFileName = showFileName;
    }
}

