/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.hyperlinks;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.ExternalBeanHyperlink;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtendedExternalBeanHyperlink
extends ExternalBeanHyperlink {
    private final IBean bean;
    private AbstractConfigEditor cEditor;
    private IFile file;
    private IDOMDocument doc;

    public ExtendedExternalBeanHyperlink(IBean bean, IRegion region) {
        super((ISourceModelElement)bean, region);
        this.bean = bean;
    }

    public void open() {
        IEditorPart editor = BeansUIUtils.openInEditor((IResourceModelElement)this.bean);
        if (editor instanceof AbstractConfigEditor) {
            this.cEditor = (AbstractConfigEditor)editor;
            this.file = this.cEditor.getResourceFile();
            this.doc = this.cEditor.getDomDocument();
            this.traverseNode((Node)this.doc);
        }
    }

    private void traverseNode(Node node) {
        int end;
        int startOffset = ((IDOMNode)node).getStartOffset();
        int endOffset = ((IDOMNode)node).getEndOffset();
        int start = this.doc.getStructuredDocument().getLineOfOffset(startOffset);
        IModelElement modelElement = BeansModelUtils.getMostSpecificModelElement((int)start, (int)(end = this.doc.getStructuredDocument().getLineOfOffset(endOffset)), (IFile)this.file, null);
        if (this.bean.equals(modelElement)) {
            this.cEditor.revealElement(node);
        } else if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                this.traverseNode(children.item(i));
                ++i;
            }
        }
    }
}

