/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.core.contentassist.SpringConfigContentAssistProcessor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigSectionPart;
import org.springframework.ide.eclipse.config.ui.editors.Messages;

public class SpringConfigDocumentationSectionPart
extends AbstractConfigSectionPart {
    private final FormToolkit toolkit;
    private final String docsUrl;
    private final SpringConfigContentAssistProcessor processor;

    public SpringConfigDocumentationSectionPart(AbstractConfigEditor editor, IDOMElement input, Composite parent, FormToolkit toolkit) {
        this(editor, input, parent, toolkit, null);
    }

    public SpringConfigDocumentationSectionPart(AbstractConfigEditor editor, IDOMElement input, Composite parent, FormToolkit toolkit, String docsUrl) {
        super(editor, input, parent, toolkit, 256);
        this.toolkit = toolkit;
        this.docsUrl = docsUrl;
        this.processor = editor.getXmlProcessor();
    }

    public void createContent() {
        Section helpSection = this.getSection();
        helpSection.setLayout((Layout)new GridLayout());
        helpSection.setLayoutData((Object)new GridData(770));
        helpSection.setText(Messages.getString("AbstractNamespaceDetailsPart.DOCUMENTATION_SECTION_TITLE"));
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        Composite helpClient = this.toolkit.createComposite((Composite)helpSection);
        helpClient.setLayout((Layout)layout);
        helpClient.setLayoutData((Object)new GridData(768));
        helpSection.setClient((Control)helpClient);
        Text text = new Text(helpClient, 74);
        text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
        TableWrapData data = new TableWrapData(256);
        text.setLayoutData((Object)data);
        String documentation = this.processor.getDocumentation(this.getInput());
        text.setText(documentation);
        if (this.docsUrl != null) {
            Hyperlink link = this.toolkit.createHyperlink(helpClient, Messages.getString("AbstractNamespaceDetailsPart.EXTERNAL_DOCUMENTATION_LINK"), 64);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    TasksUiUtil.openUrl((String)SpringConfigDocumentationSectionPart.this.docsUrl);
                }
            });
        }
    }
}

