/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;

public class SpringConfigContentOutline
extends Page
implements IContentOutlinePage,
ISelectionChangedListener {
    private final AbstractConfigEditor editor;
    private ArrayList<ISelectionChangedListener> listeners;
    private Set<IContentOutlinePage> pages;
    private PageBook pagebook;
    private IContentOutlinePage currentOutline;
    private ISelection selection;

    public SpringConfigContentOutline(AbstractConfigEditor editor) {
        this.editor = editor;
        this.listeners = new ArrayList();
        this.pages = new HashSet<IContentOutlinePage>();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void createControl(Composite parent) {
        this.pagebook = new PageBook(parent, 0);
    }

    public void dispose() {
        if (this.pagebook != null && !this.pagebook.isDisposed()) {
            this.pagebook.dispose();
        }
        this.pagebook = null;
        this.listeners = null;
        this.releasePages();
    }

    public Control getControl() {
        return this.pagebook;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void init(IPageSite pageSite) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (this.pages == null) {
            this.pages = new HashSet<IContentOutlinePage>();
        }
        super.init(pageSite);
    }

    private void releasePages() {
        for (IContentOutlinePage outline : this.pages) {
            if (outline == null) continue;
            if (outline instanceof ConfigurableContentOutlinePage) {
                ((ConfigurableContentOutlinePage)outline).setEditorPart(null);
            }
            try {
                outline.dispose();
            }
            catch (Exception exception) {}
        }
        this.pages = null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        if (this.currentOutline != null) {
            this.setActiveOutline(this.currentOutline);
        }
    }

    public void setActiveOutline(IContentOutlinePage outline) {
        if (this.currentOutline != null) {
            this.currentOutline.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        outline.addSelectionChangedListener((ISelectionChangedListener)this);
        this.pages.add(outline);
        this.currentOutline = outline;
        if (this.pagebook == null) {
            return;
        }
        Control control = outline.getControl();
        if (control == null || control.isDisposed()) {
            if (outline instanceof Page) {
                Page page = (Page)outline;
                page.init(this.getSite());
            }
            outline.createControl((Composite)this.pagebook);
            control = outline.getControl();
        }
        this.pagebook.showPage(control);
        this.currentOutline = outline;
    }

    public void setFocus() {
        if (this.currentOutline != null) {
            this.currentOutline.setFocus();
        }
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        if (this.listeners == null) {
            return;
        }
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(e);
        }
    }
}

