/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.core.extensions.CommonActionsExtensionPointConstants;
import org.springframework.ide.eclipse.config.core.extensions.PageAdaptersExtensionPointConstants;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigDetailsPart;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigFormPage;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigMasterDetailsBlock;
import org.springframework.ide.eclipse.config.ui.editors.AbstractNamespaceDetailsPart;
import org.springframework.ide.eclipse.config.ui.editors.Messages;
import org.springframework.ide.eclipse.config.ui.wizards.AbstractConfigWizard;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public abstract class AbstractNamespaceMasterDetailsBlock
extends AbstractConfigMasterDetailsBlock {
    public AbstractNamespaceMasterDetailsBlock() {
        this(null);
    }

    public AbstractNamespaceMasterDetailsBlock(AbstractConfigFormPage page) {
        super(page);
    }

    protected void createMasterPart(IManagedForm managedForm, Composite parent) {
        super.createMasterPart(managedForm, parent);
        Composite container = this.getMasterPart().getSection().getParent();
        SectionPart templatePart = this.createTemplateSectionPart(container, managedForm.getToolkit(), 256);
        if (templatePart != null) {
            managedForm.addPart((IFormPart)templatePart);
        }
    }

    private SectionPart createTemplateSectionPart(Composite parent, FormToolkit toolkit, int style) {
        if (this.getFormPage().getWizardDefinitions().size() > 0) {
            TableWrapLayout wrapperLayout = new TableWrapLayout();
            wrapperLayout.topMargin = 0;
            wrapperLayout.bottomMargin = 0;
            wrapperLayout.leftMargin = 0;
            wrapperLayout.rightMargin = 0;
            wrapperLayout.horizontalSpacing = 0;
            wrapperLayout.verticalSpacing = 0;
            Composite wrapper = toolkit.createComposite(parent);
            wrapper.setLayout((Layout)wrapperLayout);
            wrapper.setLayoutData((Object)new GridData(770));
            SectionPart sectionPart = new SectionPart(wrapper, toolkit, style);
            Section templateSection = sectionPart.getSection();
            templateSection.setText(Messages.getString("AbstractConfigMasterDetailsBlock.COMMON_ACTIONS_SECTION_TITLE"));
            ScrolledComposite scroll = new ScrolledComposite((Composite)templateSection, 512);
            GC gc = new GC((Drawable)scroll);
            FontMetrics fm = gc.getFontMetrics();
            int height = 10 * fm.getHeight();
            gc.dispose();
            TableWrapData data = new TableWrapData(256);
            data.maxHeight = scroll.computeSize((int)-1, (int)height).y;
            templateSection.setLayout((Layout)new TableWrapLayout());
            templateSection.setLayoutData((Object)data);
            TableWrapLayout layout = new TableWrapLayout();
            layout.leftMargin = 0;
            layout.rightMargin = 0;
            Composite templateClient = toolkit.createComposite((Composite)scroll);
            templateClient.setLayout((Layout)layout);
            templateClient.setLayoutData((Object)new TableWrapData(256));
            scroll.setContent((Control)templateClient);
            templateSection.setClient((Control)scroll);
            toolkit.adapt((Composite)scroll);
            for (final IConfigurationElement def : this.getFormPage().getWizardDefinitions()) {
                Hyperlink wizardLink = toolkit.createHyperlink(templateClient, def.getAttribute(CommonActionsExtensionPointConstants.ATTR_DESCRIPTION), 64);
                wizardLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        try {
                            AbstractConfigWizard wizard = (AbstractConfigWizard)((Object)def.createExecutableExtension(CommonActionsExtensionPointConstants.ATTR_CLASS));
                            wizard.initialize(AbstractNamespaceMasterDetailsBlock.this.getFormPage().getEditor().getResourceFile(), AbstractNamespaceMasterDetailsBlock.this.getFormPage().getEditor().getDomDocument(), def.getAttribute(CommonActionsExtensionPointConstants.ATTR_NAMESPACE_URI));
                            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                            if (shell != null && !shell.isDisposed()) {
                                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                                dialog.create();
                                dialog.setBlockOnOpen(true);
                                if (dialog.open() == 0) {
                                    IDOMElement element = wizard.getNewElement();
                                    AbstractNamespaceMasterDetailsBlock.this.getMasterPart().getViewer().setSelection((ISelection)new StructuredSelection((Object)element));
                                }
                            }
                        }
                        catch (CoreException e1) {
                            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("AbstractConfigMasterDetailsBlock.ERROR_LOADING_WIZARD_CONTRIBUTION"), (Throwable)e1));
                        }
                    }
                });
            }
            templateClient.setSize(templateClient.computeSize(-1, -1));
            templateClient.layout();
            return sectionPart;
        }
        return null;
    }

    public abstract AbstractConfigDetailsPart getDetailsPage(Object var1);

    public AbstractConfigDetailsPart getPage(Object key) {
        if (key instanceof IDOMElement) {
            IDOMElement element = (IDOMElement)key;
            if (this.getFormPage().getNamespaceUri().equals(element.getNamespaceURI())) {
                return this.getDetailsPage(element);
            }
            for (IConfigurationElement config : this.getFormPage().getAdapterDefinitions()) {
                String uri = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_NAMESPACE_URI);
                if (!uri.equals(element.getNamespaceURI())) continue;
                if (config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_DETAILS_FACTORY) == null) {
                    return new AbstractNamespaceDetailsPart(this.getMasterPart());
                }
                try {
                    Object obj = config.createExecutableExtension(PageAdaptersExtensionPointConstants.ATTR_DETAILS_FACTORY);
                    if (!(obj instanceof AbstractNamespaceMasterDetailsBlock)) continue;
                    AbstractNamespaceMasterDetailsBlock factory = (AbstractNamespaceMasterDetailsBlock)((Object)obj);
                    factory.setFormPage(this.getFormPage());
                    AbstractConfigDetailsPart page = factory.getDetailsPage(element);
                    page.setMasterPart(this.getMasterPart());
                    return page;
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("AbstractConfigMasterDetailsBlock.ERROR_LOADING_DETAILS"), (Throwable)e));
                }
            }
        }
        return null;
    }
}

