/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.core.contentassist.SpringConfigContentAssistProcessor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigDetailsPart;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigMasterPart;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigSectionPart;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigDetailsSectionPart;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigDocumentationSectionPart;

public class AbstractNamespaceDetailsPart
extends AbstractConfigDetailsPart {
    public static final String DOCS_SPRINGFRAMEWORK_25 = "http://static.springsource.org/spring/docs/2.5.x/reference/index.html";
    public static final String DOCS_SPRINGFRAMEWORK_30 = "http://static.springsource.org/spring/docs/3.0.x/spring-framework-reference/html/";
    private final SpringConfigContentAssistProcessor processor;
    protected AbstractConfigSectionPart docsSection;
    private final String docsUrl;

    public AbstractNamespaceDetailsPart(AbstractConfigMasterPart master) {
        this(master, DOCS_SPRINGFRAMEWORK_30);
    }

    public AbstractNamespaceDetailsPart(AbstractConfigMasterPart master, String docsUrl) {
        super(master);
        this.docsUrl = docsUrl;
        this.processor = new SpringConfigContentAssistProcessor();
    }

    public void createContents(Composite parent) {
        super.createContents(parent);
        this.createDocumentationSection(parent);
    }

    protected void createDetailsContent(Composite client) {
    }

    protected void createDetailsSection(Composite parent) {
        if (this.requiresDetailsSection()) {
            super.createDetailsSection(parent);
        }
    }

    public SpringConfigDetailsSectionPart createDetailsSectionPart(AbstractConfigEditor editor, IDOMElement input, Composite parent, FormToolkit toolkit) {
        return new SpringConfigDetailsSectionPart(editor, input, parent, toolkit);
    }

    protected void createDocumentationSection(Composite parent) {
        if (this.requiresDocumentationSection()) {
            this.docsSection = this.createDocumentationSectionPart(this.getConfigEditor(), this.getInput(), parent, this.toolkit);
            this.docsSection.createContent();
            this.alignSectionHeaderWithMaster(this.docsSection.getSection());
        }
    }

    public SpringConfigDocumentationSectionPart createDocumentationSectionPart(AbstractConfigEditor editor, IDOMElement input, Composite parent, FormToolkit toolkit) {
        return new SpringConfigDocumentationSectionPart(editor, input, parent, toolkit, this.docsUrl);
    }

    public void dispose() {
        this.processor.release();
        super.dispose();
    }

    protected String getDetailsSectionDescription() {
        return null;
    }

    protected String getDetailsSectionTitle() {
        return null;
    }

    public AbstractConfigSectionPart getDocumentationSection() {
        return this.docsSection;
    }

    public void refresh() {
        if (this.docsSection != null) {
            this.docsSection.refresh();
        }
        super.refresh();
    }

    private boolean requiresDetailsSection() {
        return !this.processor.getAttributeDeclarations(this.getInput()).isEmpty() || this.processor.allowsCharacterData(this.getInput());
    }

    private boolean requiresDocumentationSection() {
        String documentation = this.processor.getDocumentation(this.getInput());
        return documentation != null && documentation.trim().length() > 0;
    }

    protected void updateInput(ISelection selection) {
        super.updateInput(selection);
        if (this.docsSection != null) {
            this.docsSection.setFormInput(this.getInput());
        }
    }
}

