/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.osgi.framework.Version;
import org.springframework.ide.eclipse.config.core.ConfigCoreUtils;
import org.springframework.ide.eclipse.config.core.IConfigEditor;
import org.springframework.ide.eclipse.config.core.IConfigEditorPage;
import org.springframework.ide.eclipse.config.core.contentassist.SpringConfigContentAssistProcessor;
import org.springframework.ide.eclipse.config.core.extensions.CommonActionsExtensionPointConstants;
import org.springframework.ide.eclipse.config.core.extensions.FormPagesExtensionPointConstants;
import org.springframework.ide.eclipse.config.core.extensions.PageAdaptersExtensionPointConstants;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigMasterDetailsBlock;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigMasterPart;
import org.springframework.ide.eclipse.config.ui.extensions.ConfigUiExtensionPointReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigFormPage
extends FormPage
implements IConfigEditorPage {
    public static String PAGE_KIND = "formPage";
    private AbstractConfigEditor cEditor;
    private final AbstractConfigMasterDetailsBlock block;
    private ScrolledForm form;
    private String pId;
    private String namespaceUri;
    private final Set<IConfigurationElement> adapterDefinitions = new HashSet<IConfigurationElement>();
    private final Set<IConfigurationElement> wizardDefinitions = new HashSet<IConfigurationElement>();

    public AbstractConfigFormPage() {
        this("", "");
    }

    public AbstractConfigFormPage(AbstractConfigEditor editor, String id, String title) {
        this(id, title);
        this.initialize(editor, null);
    }

    private AbstractConfigFormPage(String id, String title) {
        super(id, title);
        this.block = this.createMasterDetailsBlock();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        this.form.getForm().setSeparatorVisible(true);
        this.form.getForm().setText(this.getTitle());
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.form.getForm());
        this.block.createContent(managedForm);
        this.getSite().setSelectionProvider((ISelectionProvider)this.getMasterPart().getViewer());
        this.updateHeader();
    }

    protected abstract AbstractConfigMasterDetailsBlock createMasterDetailsBlock();

    public void doSaveAs() {
        this.setInput(this.cEditor.getEditorInput());
        AbstractConfigMasterPart master = this.getMasterPart();
        if (master != null) {
            master.getViewer().setInput((Object)this.cEditor.getDomDocument());
        }
        this.modelUpdated();
    }

    protected Set<IConfigurationElement> getAdapterDefinitions() {
        return this.adapterDefinitions;
    }

    public AbstractConfigEditor getEditor() {
        return this.cEditor;
    }

    public String getId() {
        if (this.pId != null) {
            return this.pId;
        }
        return super.getId();
    }

    public AbstractConfigMasterDetailsBlock getMasterDetailsBlock() {
        return this.block;
    }

    public AbstractConfigMasterPart getMasterPart() {
        if (this.block != null) {
            return this.block.getMasterPart();
        }
        return null;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getPageKind() {
        return PAGE_KIND;
    }

    public String getPrefixForNamespaceUri() {
        return ConfigCoreUtils.getPrefixForNamespaceUri((IDOMDocument)this.cEditor.getDomDocument(), (String)this.namespaceUri);
    }

    public Version getSchemaVersion() {
        return ConfigCoreUtils.getSchemaVersion((IDOMDocument)this.cEditor.getDomDocument(), (String)this.namespaceUri);
    }

    public ScrolledForm getScrolledForm() {
        return this.form;
    }

    protected Set<IConfigurationElement> getWizardDefinitions() {
        return this.wizardDefinitions;
    }

    public SpringConfigContentAssistProcessor getXmlProcessor() {
        return this.getEditor().getXmlProcessor();
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init((IEditorSite)new MultiPageEditorSite((MultiPageEditorPart)this.getEditor(), (IEditorPart)this), input);
    }

    private void initAdapterDefinitions() {
        Set<IConfigurationElement> allAdapters = ConfigUiExtensionPointReader.getAdapterDefinitions();
        for (IConfigurationElement config : allAdapters) {
            String parent = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_PARENT_URI);
            String uri = config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_NAMESPACE_URI);
            if (parent == null || !parent.equals(this.namespaceUri) || uri == null) continue;
            this.adapterDefinitions.add(config);
        }
    }

    public void initialize(IConfigEditor editor, String uri) {
        this.cEditor = (AbstractConfigEditor)editor;
        this.namespaceUri = uri;
        this.initAdapterDefinitions();
        this.initWizardDefinitions();
        super.initialize((FormEditor)this.cEditor);
    }

    private void initWizardDefinitions() {
        Set<IConfigurationElement> allWizards = ConfigUiExtensionPointReader.getWizardDefinitions();
        for (IConfigurationElement config : allWizards) {
            String uri = config.getAttribute(CommonActionsExtensionPointConstants.ATTR_NAMESPACE_URI);
            if (uri == null || !uri.equals(this.namespaceUri)) continue;
            this.wizardDefinitions.add(config);
        }
    }

    public void modelUpdated() {
        AbstractConfigMasterPart master;
        if (this.isActive() && (master = this.getMasterPart()) != null) {
            master.markStale();
        }
    }

    public void namespacesUpdated() {
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.modelUpdated();
            this.updateHeader();
        }
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        String id;
        if (cfig != null && (id = cfig.getAttribute(FormPagesExtensionPointConstants.ATTR_ID)) != null && id.trim().length() > 0) {
            this.pId = id;
        }
        super.setInitializationData(cfig, propertyName, data);
    }

    public void setSelection(ISelection selection) {
        this.getSite().getSelectionProvider().setSelection(selection);
    }

    public void updateHeader() {
        this.cEditor.getHeaderMessage().setMessage(this);
    }
}

