/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.content.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.springsource.ide.eclipse.commons.content.core.ContentItem;
import org.springsource.ide.eclipse.commons.content.core.TemplateDownloader;
import org.springsource.ide.eclipse.commons.content.core.util.Descriptor;
import org.springsource.ide.eclipse.commons.content.core.util.DescriptorReader;
import org.springsource.ide.eclipse.commons.core.HttpUtil;
import org.springsource.ide.eclipse.commons.core.ResourceProvider;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.internal.content.core.DescriptorMatcher;

public class ContentManager {
    private static final boolean DEBUG = ("" + Platform.getLocation()).contains("bamboo");
    private boolean isRefreshing = false;
    private boolean isDirty = true;
    public static final String EVENT_REFRESH = "refresh";
    public static final String KIND_SAMPLE = "sample";
    public static final String KIND_TEMPLATE = "template";
    public static final String KIND_TUTORIAL = "tutorial";
    private static final String DIRECTORY_METADATA = ".metadata";
    private static final String DIRECTORY_STS = ".sts";
    private static final String DIRECTORY_INSTALL = "content";
    public static final String ARCHIVE_EXTENSION = ".zip";
    public static final String[] DESCRIPTOR_FILENAMES = new String[]{"sample.xml", "tutorial.xml", "server.xml", "template.xml"};
    public static final String RESOURCE_CONTENT_DESCRIPTORS = "content.descriptors";
    private final Map<String, ContentItem> itemById = new HashMap<String, ContentItem>();
    private final Map<String, Set<ContentItem>> itemsByKind = new HashMap<String, Set<ContentItem>>();
    private final List<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private File stateFile;
    private File defaultStateFile;

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    private static void debug(String msg) {
        if (DEBUG) {
            System.out.println(msg);
        }
    }

    private void debug(Exception e) {
        if (DEBUG) {
            e.printStackTrace(System.out);
        }
    }

    public void addListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public TemplateDownloader createDownloader(ContentItem item) {
        return new TemplateDownloader(item);
    }

    private ContentItem createItem(Descriptor descriptor) {
        String id = descriptor.getId();
        ContentItem item = new ContentItem(id);
        this.itemById.put(id, item);
        String kind = descriptor.getKind();
        Set<ContentItem> items = this.itemsByKind.get(kind);
        if (items == null) {
            items = new HashSet<ContentItem>();
            this.itemsByKind.put(kind, items);
        }
        items.add(item);
        return item;
    }

    private void firePropertyChangeEvent(String eventName) {
        PropertyChangeListener[] listeners = this.listeners.toArray(new PropertyChangeListener[0]);
        if (listeners.length > 0) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, eventName, null, null);
            PropertyChangeListener[] propertyChangeListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeListener listener = propertyChangeListenerArray[n2];
                listener.propertyChange(event);
                ++n2;
            }
        }
    }

    public File getDataDirectory() {
        return new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(DIRECTORY_METADATA).append(DIRECTORY_STS).toOSString());
    }

    public File getDefaultStateFile() {
        return this.defaultStateFile;
    }

    public List<ContentItem> getDependencies(ContentItem item) throws CoreException {
        ArrayList<ContentItem> results = new ArrayList<ContentItem>();
        Stack<ContentItem> queue = new Stack<ContentItem>();
        queue.add(item);
        while (!queue.isEmpty()) {
            ContentItem next = (ContentItem)queue.pop();
            results.add(next);
            List<Descriptor.Dependency> dependencies = next.getRemoteDescriptor().getDependencies();
            for (Descriptor.Dependency dependency : dependencies) {
                ContentItem dependentItem = this.itemById.get(dependency.getId());
                if (dependentItem == null) {
                    String message = NLS.bind((String)"Failed to resolve dependencies: ''{0}'' requires ''{1}'' which is not available", (Object)next.getId(), (Object)dependency.getId());
                    throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", message));
                }
                if (!dependentItem.needsDownload() || results.contains(dependentItem)) continue;
                queue.add(dependentItem);
            }
        }
        return results;
    }

    public File getInstallDirectory() {
        return new File(this.getDataDirectory(), DIRECTORY_INSTALL);
    }

    public File getInstallDirectory(ContentItem item) {
        return new File(this.getInstallDirectory(), item.getPath());
    }

    public ContentItem getItem(String id) {
        return this.itemById.get(id);
    }

    public Collection<ContentItem> getItems() {
        return new HashSet<ContentItem>(this.itemById.values());
    }

    public Collection<ContentItem> getItemsByKind(String kind) {
        Set<ContentItem> items = this.itemsByKind.get(kind);
        if (items == null) {
            items = new HashSet<ContentItem>();
        }
        return Collections.unmodifiableCollection(items);
    }

    private Set<String> getRemoteDescriptorLocations() {
        return new HashSet<String>(Arrays.asList(ResourceProvider.getUrls((String)RESOURCE_CONTENT_DESCRIPTORS)));
    }

    public File getStateFile() {
        return this.stateFile;
    }

    public void init() {
        this.itemById.clear();
        this.itemsByKind.clear();
        MultiStatus result = new MultiStatus("org.springsource.ide.eclipse.commons.content.core", 0, NLS.bind((String)"Reading of content failed", null), null);
        File file = this.getStateFile();
        if (file != null && file.exists()) {
            try {
                this.read(file);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(2, "org.springsource.ide.eclipse.commons.content.core", NLS.bind((String)"Detected error in ''{0}''", (Object)file.getAbsoluteFile()), (Throwable)e));
            }
        }
        if ((file = this.getDefaultStateFile()) != null) {
            try {
                this.read(file);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)new Status(2, "org.springsource.ide.eclipse.commons.content.core", NLS.bind((String)"Detected error in ''{0}''", (Object)file.getAbsoluteFile()), (Throwable)e));
            }
        }
        if (!result.isOK()) {
            StatusHandler.log((IStatus)result);
        }
        this.firePropertyChangeEvent(EVENT_REFRESH);
    }

    private void read(File file) throws CoreException {
        DescriptorMatcher matcher = new DescriptorMatcher(this);
        DescriptorReader reader = new DescriptorReader();
        reader.read(file);
        List<Descriptor> descriptors = reader.getDescriptors();
        for (Descriptor descriptor : descriptors) {
            if (!matcher.match(descriptor)) continue;
            ContentItem item = this.itemById.get(descriptor.getId());
            if (item == null && (item = this.createItem(descriptor)) != null) {
                this.itemById.put(item.getId(), item);
            }
            if (item == null) continue;
            if (descriptor.isLocal()) {
                item.setLocalDescriptor(descriptor);
                continue;
            }
            item.setRemoteDescriptor(descriptor);
        }
    }

    private void readFromUrl(DescriptorReader reader, String location, IProgressMonitor monitor) throws CoreException {
        ContentManager.debug("entering readFromURL: " + location);
        try {
            URI uri = new URI(location);
            InputStream in = HttpUtil.stream((URI)uri, (IProgressMonitor)monitor);
            try {
                try {
                    reader.read(in);
                }
                catch (Exception e) {
                    String message = NLS.bind((String)"Error downloading {0} - Internet connection might be down", (Object)location);
                    throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", message, (Throwable)e));
                }
            }
            finally {
                ContentManager.debug("exiting readFromURL: " + location);
                try {
                    in.close();
                }
                catch (IOException e) {
                    String message = NLS.bind((String)"No route to {0} - Internet connection might be down", (Object)location);
                    throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", message, (Throwable)e));
                }
            }
        }
        catch (URISyntaxException e) {
            this.debug(e);
            String message = NLS.bind((String)"I/O error while retrieving data: ", (Object)e);
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", message, (Throwable)e));
        }
        catch (CoreException e) {
            String message = NLS.bind((String)"Error while retrieving {0}", (Object)location);
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", message, (Throwable)e));
        }
    }

    public IStatus refresh(IProgressMonitor monitor, boolean shouldDownloadRemotes) {
        File targetFile = this.getStateFile();
        Assert.isNotNull((Object)targetFile, (String)"stateFile not initialized");
        this.isRefreshing = true;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            String message;
            progress.beginTask("Refreshing", 200);
            MultiStatus result = new MultiStatus("org.springsource.ide.eclipse.commons.content.core", 0, "Results of template project refresh:", null);
            DescriptorReader reader = new DescriptorReader();
            if (shouldDownloadRemotes) {
                this.markLocalTemplatesAsLocal(progress, result, reader);
                for (String descriptorLocation : this.getRemoteDescriptorLocations()) {
                    try {
                        if (descriptorLocation == null || descriptorLocation.length() <= 0) continue;
                        this.readFromUrl(reader, descriptorLocation, (IProgressMonitor)progress.newChild(70));
                    }
                    catch (CoreException e) {
                        String message2 = NLS.bind((String)"Error while downloading or parsing descriptors file ''{0}'':\n\n{1}", (Object)descriptorLocation, (Object)((Object)e));
                        result.add((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", message2, (Throwable)e));
                    }
                }
            } else {
                try {
                    reader.read(targetFile);
                }
                catch (CoreException e) {
                    message = NLS.bind((String)"Failed to store updated descriptors to ''{0}''", (Object)targetFile.getAbsolutePath());
                    result.add((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", message, (Throwable)e));
                }
                this.markLocalTemplatesAsLocal(progress, result, reader);
            }
            try {
                if (result.isOK()) {
                    reader.write(targetFile);
                    this.init();
                }
            }
            catch (CoreException e) {
                message = NLS.bind((String)"Failed to store updated descriptors to ''{0}''", (Object)targetFile.getAbsolutePath());
                result.add((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.content.core", message, (Throwable)e));
            }
            if (result.isOK()) {
                this.isDirty = false;
            }
            MultiStatus multiStatus = result;
            return multiStatus;
        }
        finally {
            this.isRefreshing = false;
            progress.done();
        }
    }

    public void markLocalTemplatesAsLocal(SubMonitor progress, MultiStatus result, DescriptorReader reader) {
        Status descriptorParseStatus = new Status(0, "org.springsource.ide.eclipse.commons.content.core", NLS.bind((String)"No descriptors were found.", null));
        File dir = this.getInstallDirectory();
        File[] children = dir.listFiles();
        if (children == null || children.length <= 0) {
            progress.setWorkRemaining(70);
            return;
        }
        SubMonitor loopProgress = progress.newChild(30).setWorkRemaining(children.length);
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File childDirectory = fileArray[n2];
            if (childDirectory.isDirectory()) {
                if (new File(childDirectory, "template.xml").exists()) {
                    descriptorParseStatus = this.setDirectoryDescriptorsToLocal(reader, childDirectory);
                } else {
                    File[] grandchildren;
                    File[] fileArray2 = grandchildren = childDirectory.listFiles();
                    int n3 = grandchildren.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File grandchildDirectory = fileArray2[n4];
                        if (grandchildDirectory.isDirectory()) {
                            descriptorParseStatus = this.setDirectoryDescriptorsToLocal(reader, grandchildDirectory);
                        }
                        ++n4;
                    }
                }
                if (!descriptorParseStatus.isOK()) {
                    result.add((IStatus)descriptorParseStatus);
                }
            }
            loopProgress.worked(1);
            ++n2;
        }
    }

    public IStatus setDirectoryDescriptorsToLocal(DescriptorReader reader, File directory) {
        boolean descriptorFound = false;
        String[] stringArray = DESCRIPTOR_FILENAMES;
        int n = DESCRIPTOR_FILENAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            File descriptorFile = new File(directory, filename);
            if (descriptorFile.exists()) {
                descriptorFound = true;
                try {
                    List<Descriptor> localDescriptors = reader.read(descriptorFile);
                    for (Descriptor descriptor : localDescriptors) {
                        descriptor.setLocal(true);
                    }
                }
                catch (CoreException e) {
                    String message = NLS.bind((String)"Error while parsing ''{0}''", (Object)descriptorFile.getAbsolutePath());
                    return new Status(4, "org.springsource.ide.eclipse.commons.content.core", message, (Throwable)e);
                }
            }
            ++n2;
        }
        if (descriptorFound) {
            return new Status(0, "org.springsource.ide.eclipse.commons.content.core", NLS.bind((String)"Everything is okay", null));
        }
        return new Status(0, "org.springsource.ide.eclipse.commons.content.core", NLS.bind((String)"There are zero descriptors, but that is okay.", null));
    }

    public void removeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void setDefaultStateFile(File defaultStateFile) {
        this.defaultStateFile = defaultStateFile;
    }

    public void setStateFile(File stateFile) {
        this.stateFile = stateFile;
    }
}

