/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.IRelationshipMap;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.javaelements.DeclareElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.jdt.core.IJavaElement;

public class AJModelChecker {
    private AJModelChecker() {
    }

    public static void doModelCheckIfRequired(AJProjectModelFacade model) {
        if (AJModelChecker.shouldCheckModel()) {
            AJLog.logStart("Model sanity check for: " + model.getProject().getName());
            List<String> problems = AJModelChecker.internalCheckModel(model);
            AJModelChecker.logProblems(problems);
            AJLog.logEnd(7, "Model sanity check for: " + model.getProject().getName());
        }
    }

    public static boolean shouldCheckModel() {
        return AjState.stateListener != null;
    }

    private static void logProblems(List<String> problems) {
        if (problems.size() == 0) {
            AJLog.log(7, "Crosscutting model sanity checked with no problems");
            return;
        }
        AJLog.log(7, "Crosscutting model sanity checked.  The following problems found:");
        for (String problem : problems) {
            AJLog.log(7, problem);
        }
        AJLog.log(7, "");
    }

    private static List<String> internalCheckModel(AJProjectModelFacade model) {
        IRelationshipMap relationships = model.getAllRelationships();
        ArrayList<String> problems = new ArrayList<String>();
        if (relationships != null) {
            for (String handle : relationships.getEntries()) {
                List relsForHandle = relationships.get(handle);
                for (IRelationship rel : relsForHandle) {
                    List<String> res = AJModelChecker.invalidAdviceRelationsip(rel, model);
                    problems.addAll(res);
                    res = AJModelChecker.itdsNotOnType(rel, model);
                    problems.addAll(res);
                }
            }
        } else {
            problems.add("No relationshipes found");
        }
        return problems;
    }

    private static List<String> invalidAdviceRelationsip(IRelationship rel, AJProjectModelFacade model) {
        ArrayList<String> problems = new ArrayList<String>();
        if (rel.getKind() == IRelationship.Kind.ADVICE || rel.getKind() == IRelationship.Kind.ADVICE_AFTER || rel.getKind() == IRelationship.Kind.ADVICE_AFTERRETURNING || rel.getKind() == IRelationship.Kind.ADVICE_AFTERTHROWING || rel.getKind() == IRelationship.Kind.ADVICE_BEFORE || rel.getKind() == IRelationship.Kind.ADVICE_AROUND) {
            IJavaElement elt = model.programElementToJavaElement(rel.getSourceHandle());
            if (!elt.exists()) {
                problems.add("Java Element does not exist: " + rel.getSourceHandle() + "\n\tIt is the source relationship of " + AJModelChecker.toRelString(rel) + "\n\tThis may not actually be a problem if compiling broken code or advising static initializers.");
            }
            if (elt.getElementType() == 5 || elt.getElementType() == 6) {
                problems.add("Java Element is wrong type (advice relationships should not contain any types or compilation units): " + rel.getSourceHandle() + "\n\tIt is the source relationship of " + AJModelChecker.toRelString(rel));
            }
            for (String target : rel.getTargets()) {
                elt = model.programElementToJavaElement(target);
                if (!elt.exists()) {
                    problems.add("Java Element does not exist: " + target + "\n\tIt is the source relationship of " + AJModelChecker.toRelString(rel) + "\n\tThis may not actually be a problem if compiling broken code or advising static initializers.");
                }
                if (elt == AJProjectModelFacade.ERROR_JAVA_ELEMENT || elt.getElementType() != 5 && elt.getElementType() != 6) continue;
                problems.add("Java Element is wrong type (advice relationships should not contain any types or compilation units): " + target + "\n\tIt is the source relationship of " + AJModelChecker.toRelString(rel));
            }
        }
        return problems;
    }

    private static List<String> itdsNotOnType(IRelationship rel, AJProjectModelFacade model) {
        ArrayList<String> problems = new ArrayList<String>();
        if (rel.getKind() == IRelationship.Kind.DECLARE_INTER_TYPE) {
            IJavaElement elt = model.programElementToJavaElement(rel.getSourceHandle());
            if (!elt.exists()) {
                problems.add("Java Element does not exist: " + rel.getSourceHandle() + "\n\tIt is the source relationship of " + AJModelChecker.toRelString(rel) + "\n\tThis may not actually be a problem if compiling broken code.");
            }
            if (!(elt == AJProjectModelFacade.ERROR_JAVA_ELEMENT || elt.getElementType() != 8 && elt.getElementType() != 9 && elt.getElementType() != 14 && elt.getElementType() != 10 && elt.getElementType() != 5 && elt.getElementType() != 6 || elt instanceof IntertypeElement || elt instanceof DeclareElement)) {
                problems.add("Java Element is wrong type (ITD relationships should only contain types and intertype elements): " + rel.getSourceHandle() + "\n\tIt is the source relationship of " + AJModelChecker.toRelString(rel));
            }
            for (String target : rel.getTargets()) {
                elt = model.programElementToJavaElement(target);
                if (!elt.exists()) {
                    problems.add("Java Element does not exist: " + target + "\n\tIt is the source relationship of " + AJModelChecker.toRelString(rel) + "\n\tThis may not actually be a problem if compiling broken code.");
                }
                if (elt == AJProjectModelFacade.ERROR_JAVA_ELEMENT || elt.getElementType() != 8 && elt.getElementType() != 9 && elt.getElementType() != 14 && elt.getElementType() != 10 && elt.getElementType() != 5 && elt.getElementType() != 6 || elt instanceof IntertypeElement || elt instanceof DeclareElement) continue;
                problems.add("Java Element is wrong type (ITD relationships should only contain types and intertype elements): " + target + "\n\tIt is the source relationship of " + AJModelChecker.toRelString(rel));
            }
        }
        return problems;
    }

    private static String toRelString(IRelationship rel) {
        StringBuffer sb = new StringBuffer();
        sb.append(rel.getSourceHandle());
        sb.append(" --");
        sb.append(rel.getName());
        sb.append("--> ");
        Iterator targetIter = rel.getTargets().iterator();
        while (targetIter.hasNext()) {
            String target = (String)targetIter.next();
            sb.append(target);
            if (!targetIter.hasNext()) continue;
            sb.append(",   ");
        }
        return sb.toString();
    }
}

