/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class StyledCommentSection
extends WizardPageSection {
    private String htmlText;
    private Font fBoldFont;

    public StyledCommentSection(IPageWithSections owner, String htmlText) {
        super(owner);
        this.htmlText = htmlText;
    }

    private StyledString.Styler createBoldStyler(final Font font) {
        return new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = StyledCommentSection.this.getBoldFont(font);
            }
        };
    }

    private Font getBoldFont(Font font) {
        if (this.fBoldFont == null) {
            FontData[] data = font.getFontData();
            int i = 0;
            while (i < data.length) {
                data[i].setStyle(1);
                ++i;
            }
            this.fBoldFont = new Font(font.getDevice(), data);
        }
        return this.fBoldFont;
    }

    @Override
    public void createContents(Composite page) {
        StyledText label = new StyledText(page, 72){

            public boolean setFocus() {
                return false;
            }

            public boolean forceFocus() {
                return false;
            }
        };
        label.setBackground(label.getParent().getBackground());
        StyledString content = new StyledString();
        this.parse(this.htmlText, content, label.getFont());
        label.setText(content.getString());
        label.setStyleRanges(content.getStyleRanges());
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (StyledCommentSection.this.fBoldFont != null) {
                    StyledCommentSection.this.fBoldFont.dispose();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).hint(310, -1).applyTo((Control)label);
    }

    private void parse(String htmlText, StyledString content, Font baseFont) {
        TokenIzer input = new TokenIzer(htmlText);
        block0: while (input.hasNext()) {
            String token = input.next();
            if ("<b>".equals(token)) {
                while (input.hasNext()) {
                    String boldedThing = input.next();
                    if (boldedThing.equals("</b>")) continue block0;
                    content.append(boldedThing, this.createBoldStyler(baseFont));
                }
                continue;
            }
            content.append(token);
        }
    }

    @Override
    public LiveExpression<ValidationResult> getValidator() {
        return Validator.OK;
    }

    class TokenIzer
    implements Iterator<String> {
        String input;
        int pos;
        Pattern tagPattern = Pattern.compile("\\<(\\/)?b\\>");
        private Matcher matcher;

        public TokenIzer(String input) {
            this.input = input;
            this.matcher = this.tagPattern.matcher(input);
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.input.length();
        }

        @Override
        public String next() {
            String token;
            Assert.isLegal((boolean)this.hasNext());
            if (this.matcher.find(this.pos)) {
                int nextTag = this.matcher.start();
                if (nextTag == this.pos) {
                    token = this.input.substring(nextTag, this.matcher.end());
                    this.pos = this.matcher.end();
                } else {
                    token = this.input.substring(this.pos, nextTag);
                    this.pos = nextTag;
                }
            } else {
                token = this.input.substring(this.pos);
                this.pos = this.input.length();
            }
            return token;
        }

        @Override
        public void remove() {
            throw new Error("Not supported");
        }
    }
}

