/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import java.util.ArrayList;
import java.util.List;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;

public class CompositeValidator
extends LiveExpression<ValidationResult>
implements ValueListener<ValidationResult> {
    private List<LiveExpression<ValidationResult>> elements = new ArrayList<LiveExpression<ValidationResult>>();

    public CompositeValidator() {
        super(ValidationResult.OK);
    }

    public CompositeValidator addChild(LiveExpression<ValidationResult> child) {
        this.elements.add(child);
        child.addListener(this);
        return this;
    }

    @Override
    protected ValidationResult compute() {
        ValidationResult worst = ValidationResult.OK;
        for (LiveExpression<ValidationResult> v : this.elements) {
            ValidationResult r = v.getValue();
            if (r != null && r.status > worst.status) {
                worst = r;
            }
            if (worst.status < 4) continue;
            return worst;
        }
        return worst;
    }

    @Override
    public void gotValue(LiveExpression<ValidationResult> exp, ValidationResult value) {
        this.refresh();
    }
}

