/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceDefinition;
import org.springframework.ide.eclipse.beans.ui.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.beans.ui.wizards.BeansWizardsMessages;
import org.springframework.ide.eclipse.beans.ui.wizards.NamespaceSelectionWizardPage;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewBeansConfigFilePage
extends WizardNewFileCreationPage {
    private Map<INamespaceDefinition, String> schemaVersions;
    private List<INamespaceDefinition> xmlSchemaDefinitions;
    private Button addNature;
    private NamespaceSelectionWizardPage namepacePage;

    public NewBeansConfigFilePage(String pageName, IStructuredSelection selection, NamespaceSelectionWizardPage namepacePage) {
        super(pageName, selection);
        this.setTitle(BeansWizardsMessages.NewConfig_title);
        this.setDescription(BeansWizardsMessages.NewConfig_fileDescription);
        this.namepacePage = namepacePage;
    }

    protected InputStream createXMLDocument() throws Exception {
        IPath containerPath = this.getContainerFullPath();
        IPath newFilePath = containerPath.append(this.getFileName());
        IFile newFileHandle = this.createFileHandle(newFilePath);
        String lineSeparator = SpringCoreUtils.getLineSeparator(null, (IProject)newFileHandle.getProject());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        String charSet = this.getUserPreferredCharset();
        INamespaceDefinition defaultXsd = NamespaceUtils.getDefaultNamespaceDefinition();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, charSet));
        writer.println("<?xml version=\"1.0\" encoding=\"" + charSet + "\"?>");
        writer.println("<beans xmlns=\"" + defaultXsd.getNamespaceURI() + "\"" + lineSeparator + "\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"" + lineSeparator + this.getNamespaceMappings(lineSeparator, newFileHandle) + "\txsi:schemaLocation=\"" + this.getSchemaLocations(lineSeparator, newFileHandle) + "\">" + lineSeparator + lineSeparator + lineSeparator + "</beans>");
        writer.flush();
        outputStream.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        return inputStream;
    }

    protected InputStream getInitialContents() {
        try {
            return this.createXMLDocument();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getNamespaceMappings(String lineSeparator, IFile file) {
        INamespaceDefinition defaultXsd = NamespaceUtils.getDefaultNamespaceDefinition();
        StringBuilder builder = new StringBuilder();
        for (INamespaceDefinition def : this.xmlSchemaDefinitions) {
            if (def.equals(defaultXsd)) continue;
            builder.append("\t");
            builder.append("xmlns:");
            builder.append(def.getNamespacePrefix((IResource)file));
            builder.append("=\"");
            builder.append(def.getNamespaceURI());
            builder.append("\"");
            builder.append(lineSeparator);
        }
        return builder.toString();
    }

    private String getSchemaLocations(String lineSeparator, IFile file) {
        StringBuilder builder = new StringBuilder();
        INamespaceDefinition defaultXsd = NamespaceUtils.getDefaultNamespaceDefinition();
        builder.append("\t\t");
        builder.append(defaultXsd.getNamespaceURI());
        builder.append(" ");
        if (this.schemaVersions.containsKey(defaultXsd)) {
            builder.append(this.schemaVersions.get(defaultXsd));
        } else {
            builder.append(defaultXsd.getDefaultSchemaLocation((IResource)file));
        }
        builder.append(lineSeparator);
        for (INamespaceDefinition def : this.xmlSchemaDefinitions) {
            if (def.getDefaultSchemaLocation((IResource)file) == null || def.equals(defaultXsd)) continue;
            builder.append("\t\t");
            builder.append(def.getNamespaceURI());
            builder.append(" ");
            if (this.schemaVersions.containsKey(def)) {
                builder.append(this.schemaVersions.get(def));
            } else {
                builder.append(def.getDefaultSchemaLocation((IResource)file));
            }
            builder.append(lineSeparator);
        }
        return builder.toString().trim();
    }

    private String getUserPreferredCharset() {
        Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
        String charSet = preference.getString("outputCodeset");
        return charSet;
    }

    public void setSchemaVersions(Map<INamespaceDefinition, String> schemaVersions) {
        this.schemaVersions = schemaVersions;
    }

    public void setXmlSchemaDefinitions(List<INamespaceDefinition> xmlSchemaDefinitions) {
        this.xmlSchemaDefinitions = xmlSchemaDefinitions;
        Collections.sort(this.xmlSchemaDefinitions, new Comparator<INamespaceDefinition>(){

            @Override
            public int compare(INamespaceDefinition o1, INamespaceDefinition o2) {
                return o1.getDefaultNamespacePrefix().compareTo(o2.getDefaultNamespacePrefix());
            }
        });
    }

    protected boolean validatePage() {
        IPath path;
        if (super.validatePage() && (path = this.getContainerFullPath()) != null && path.segment(0) != null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            if (!SpringCoreUtils.isSpringProject((IResource)project) && !this.addNature.getSelection()) {
                this.setErrorMessage("Selected folder does not belong to a Spring project.");
                return false;
            }
            return true;
        }
        return false;
    }

    protected void createAdvancedControls(Composite parent) {
        super.createAdvancedControls(parent);
        this.addNature = new Button(parent, 32);
        this.addNature.setText("Add Spring project nature if required");
        this.addNature.setSelection(true);
        this.addNature.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewBeansConfigFilePage.this.validatePage();
            }
        });
    }

    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            this.namepacePage.setFilePath(this.getContainerFullPath());
            return true;
        }
        return false;
    }
}

