/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.namespaces;

import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.ui.BeansUILabels;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabels;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.ModelUtils;
import org.springframework.util.StringUtils;

public final class DefaultNamespaceLabels
extends BeansUILabels {
    public static String getElementLabel(IModelElement element, int flags) {
        StringBuffer buf = new StringBuffer(60);
        DefaultNamespaceLabels.appendElementLabel(element, flags, buf);
        return buf.toString();
    }

    public static void appendElementLabel(IModelElement element, int flags, StringBuffer buf) {
        if (DefaultNamespaceLabels.isFlagged(flags, 1)) {
            BeansModelLabels.appendElementPathLabel(element, flags, buf);
            buf.append(" - ");
        }
        if (element instanceof IBeansComponent) {
            DefaultNamespaceLabels.appendBeansComponentLabel((IBeansComponent)element, buf);
        } else if (element instanceof IBean) {
            DefaultNamespaceLabels.appendBeanLabel((IBean)element, buf);
        } else if (element instanceof ISourceModelElement) {
            BeansModelLabels.appendElementLabel((IModelElement)((ISourceModelElement)element), buf);
        } else {
            buf.append(element.getElementName());
        }
        if (DefaultNamespaceLabels.isFlagged(flags, 2)) {
            buf.append(" - ");
            BeansModelLabels.appendElementPathLabel(element, flags, buf);
        }
    }

    public static void appendBeansComponentLabel(IBeansComponent component, StringBuffer buf) {
        String compName = component.getElementName();
        if (DefaultNamespaceLabels.appendNodeName((ISourceModelElement)component, buf)) {
            if (compName.equals(ModelUtils.getNodeName((ISourceModelElement)component))) {
                return;
            }
            buf.append(' ');
        }
        buf.append(component.getElementName());
    }

    public static void appendBeanLabel(IBean bean, StringBuffer buf) {
        if (!bean.isInnerBean()) {
            if (DefaultNamespaceLabels.appendNodeName((ISourceModelElement)bean, buf)) {
                buf.append(' ');
            }
            if (StringUtils.hasText((String)bean.getElementName())) {
                buf.append(bean.getElementName()).append(' ');
            }
        }
        if (bean.isRootBean()) {
            buf.append('[').append(bean.getClassName()).append(']');
        } else {
            buf.append('<').append(bean.getParentName()).append('>');
        }
    }
}

