/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.ui.BeansUIActivationHistory;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelProvider;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.util.StringUtils;

public class BeanListSelectionDialog
extends SelectionStatusDialog {
    private static final String DIALOG_SETTINGS = BeanListSelectionDialog.class.getName();
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private int fHeight = 18;
    private CLabel fLabel;
    private Point fLocation;
    private IDialogSettings fSettings;
    private Point fSize;
    private int fWidth = 60;
    private final LabelProvider labelProvider = new BeansModelLabelProvider(true);
    private TableViewer viewer;

    public BeanListSelectionDialog(Shell parent) {
        super(parent);
        this.setTitle(BeansUIPlugin.getResourceString("BeanListSelectionDialog.title"));
        this.setStatusLineAboveButtons(true);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setBlockOnOpen(true);
        IDialogSettings settings = BeansUIPlugin.getDefault().getDialogSettings();
        this.fSettings = settings.getSection(DIALOG_SETTINGS);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(DIALOG_SETTINGS);
            settings.addSection(this.fSettings);
            this.fSettings.put(WIDTH, 480);
            this.fSettings.put(HEIGHT, 320);
        }
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }

    protected void computeResult() {
        this.setResult(((IStructuredSelection)this.viewer.getSelection()).toList());
    }

    protected Control createDialogArea(Composite parent) {
        this.readSettings();
        Composite area = (Composite)super.createDialogArea(parent);
        Label message = new Label(area, 0);
        message.setText(BeansUIPlugin.getResourceString("BeanListSelectionDialog.message"));
        final Text filterText = new Text(area, 2052);
        filterText.setLayoutData((Object)new GridData(4, -1, true, false));
        Label matches = new Label(area, 0);
        matches.setText("&Matching beans:");
        this.viewer = new TableViewer(area, 2052);
        Control control = this.viewer.getControl();
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        gd.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        control.setLayoutData((Object)gd);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        final LinkedHashSet beanList = new LinkedHashSet();
        final ArrayList historyList = new ArrayList();
        final ArrayList<IBean> historyBeans = new ArrayList<IBean>();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    historyBeans.addAll(BeansUIActivationHistory.getBeanActivationHistory());
                    Collections.reverse(historyBeans);
                    historyList.addAll(historyBeans);
                    HashSet beans = new HashSet();
                    IBeansModel beansModel = BeansCorePlugin.getModel();
                    beans.addAll(BeansModelUtils.getBeans((IModelElement)beansModel, (IProgressMonitor)monitor));
                    beanList.addAll(historyBeans);
                    beanList.addAll(beans);
                }
                catch (OperationCanceledException operationCanceledException) {
                    throw new InterruptedException();
                }
            }
        };
        try {
            ProgressMonitorDialog context = new ProgressMonitorDialog(this.getShell());
            context.run(true, true, runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        this.viewer.setInput(beanList);
        final BeanFilter filter = new BeanFilter(historyBeans);
        this.viewer.addFilter((ViewerFilter)filter);
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IBean t1 = this.getCorrespondingTask(e1);
                IBean t2 = this.getCorrespondingTask(e2);
                boolean isInHistory1 = historyList.contains(t1);
                boolean isInHistory2 = historyList.contains(t2);
                if (isInHistory1 && !isInHistory2) {
                    return -1;
                }
                if (!isInHistory1 && isInHistory2) {
                    return 1;
                }
                if (isInHistory1 && isInHistory2) {
                    return historyList.indexOf(t1) - historyList.indexOf(t2);
                }
                return BeanListSelectionDialog.this.labelProvider.getText(e1).compareTo(BeanListSelectionDialog.this.labelProvider.getText(e2));
            }

            private IBean getCorrespondingTask(Object o) {
                if (o instanceof IBean) {
                    return (IBean)o;
                }
                return null;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BeanListSelectionDialog.this.handleSelectionChanged();
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (BeanListSelectionDialog.this.getOkButton().getEnabled()) {
                    BeanListSelectionDialog.this.okPressed();
                }
            }
        });
        filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    BeanListSelectionDialog.this.viewer.getControl().setFocus();
                }
            }
        });
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                filter.setFilterText(filterText.getText());
                BeanListSelectionDialog.this.viewer.refresh(false);
                Object first = BeanListSelectionDialog.this.viewer.getElementAt(0);
                if (first != null) {
                    BeanListSelectionDialog.this.viewer.setSelection((ISelection)new StructuredSelection(first));
                }
            }
        });
        ViewForm fForm = new ViewForm(area, 0x800800);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        fForm.setLayoutData((Object)gd);
        this.fLabel = new CLabel((Composite)fForm, 0x800000);
        this.fLabel.setFont(fForm.getFont());
        fForm.setContent((Control)this.fLabel);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof ITextSelection) {
            String text = ((ITextSelection)selection).getText();
            int n = text.indexOf(10);
            if (n > -1) {
                text = text.substring(0, n);
            }
            filterText.setText(text);
            filterText.setSelection(0, text.length());
        }
        return area;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        if (this.fLocation != null) {
            int ye;
            result.x = this.fLocation.x;
            result.y = this.fLocation.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        if (this.fSize != null) {
            result.x = Math.max(result.x, this.fSize.x);
            result.y = Math.max(result.y, this.fSize.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected void handleSelectionChanged() {
        this.validateCurrentSelection();
        if (!this.viewer.getSelection().isEmpty()) {
            ISelection sel = this.viewer.getSelection();
            if (sel instanceof IStructuredSelection) {
                IBean bean = (IBean)((IStructuredSelection)sel).getFirstElement();
                this.fLabel.setImage(this.labelProvider.getImage((Object)bean.getElementParent()));
                this.fLabel.setText(bean.getElementResource().getFullPath().toString().substring(1));
            }
        } else {
            this.fLabel.setImage(null);
            this.fLabel.setText(null);
        }
    }

    private void readSettings() {
        try {
            int x = this.fSettings.getInt("x");
            int y = this.fSettings.getInt("y");
            this.fLocation = new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            this.fLocation = null;
        }
        try {
            int width = this.fSettings.getInt(WIDTH);
            int height = this.fSettings.getInt(HEIGHT);
            this.fSize = new Point(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            this.fSize = null;
        }
    }

    protected boolean validateCurrentSelection() {
        Status status = this.viewer.getSelection().isEmpty() ? new Status(4, "org.eclipse.ui", 4, "", null) : new Status(0, "org.eclipse.ui", 0, "", null);
        this.updateStatus((IStatus)status);
        return status.isOK();
    }

    private void writeSettings() {
        Point location = this.getShell().getLocation();
        this.fSettings.put("x", location.x);
        this.fSettings.put("y", location.y);
        Point size = this.getShell().getSize();
        this.fSettings.put(WIDTH, size.x);
        this.fSettings.put(HEIGHT, size.y);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanFilter
    extends ViewerFilter {
        private StringMatcher matcher;
        private boolean isUpperCasePattern;
        private String filterText;
        private List<IBean> beanActivationHistory;

        protected BeanFilter(List<IBean> historyBeans) {
            this.beanActivationHistory = historyBeans;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.matcher == null) {
                return this.beanActivationHistory.contains(element);
            }
            if (element instanceof IBean) {
                IBean bean = (IBean)element;
                if (this.matcher.match(bean.getElementName())) {
                    return true;
                }
                if (this.matcher.match(bean.getClassName())) {
                    return true;
                }
                String[] aliases = bean.getAliases();
                if (aliases != null) {
                    String[] stringArray = aliases;
                    int n = aliases.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String alias = stringArray[n2];
                        if (this.matcher.match(alias)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                if (this.isUpperCasePattern) {
                    int i;
                    if (SearchPattern.camelCaseMatch((String)this.filterText, (String)StringUtils.capitalize((String)bean.getElementName()))) {
                        return true;
                    }
                    String className = bean.getClassName();
                    if (className != null && ((i = className.lastIndexOf(46)) > 0 && i < className.length() ? SearchPattern.camelCaseMatch((String)this.filterText, (int)0, (int)this.filterText.length(), (String)className, (int)(i + 1), (int)className.length()) : SearchPattern.camelCaseMatch((String)this.filterText, (String)className))) {
                        return true;
                    }
                }
            }
            return false;
        }

        public void setFilterText(String filterText) {
            if (filterText.trim().equals("")) {
                this.matcher = null;
                this.isUpperCasePattern = false;
                this.filterText = null;
            } else {
                this.matcher = new StringMatcher(String.valueOf(filterText) + '*', true, false);
                this.isUpperCasePattern = true;
                char[] cArray = filterText.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (Character.isLowerCase(c)) {
                        this.isUpperCasePattern = false;
                        break;
                    }
                    ++n2;
                }
                this.filterText = filterText;
            }
        }
    }
}

