/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.HateoasSortHandlerMethodArgumentResolver;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.hateoas.mvc.UriComponentsContributor;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class HateoasPageableHandlerMethodArgumentResolver
extends PageableHandlerMethodArgumentResolver
implements UriComponentsContributor {
    @Deprecated
    public static final HateoasPageableHandlerMethodArgumentResolver LEGACY;
    private static final HateoasSortHandlerMethodArgumentResolver DEFAULT_SORT_RESOLVER;
    private final HateoasSortHandlerMethodArgumentResolver sortResolver;

    public HateoasPageableHandlerMethodArgumentResolver() {
        this(null);
    }

    public HateoasPageableHandlerMethodArgumentResolver(HateoasSortHandlerMethodArgumentResolver sortResolver) {
        super(HateoasPageableHandlerMethodArgumentResolver.getDefaultedSortResolver(sortResolver));
        this.sortResolver = HateoasPageableHandlerMethodArgumentResolver.getDefaultedSortResolver(sortResolver);
    }

    public String getPaginationTemplateVariables(MethodParameter parameter, UriComponents template) {
        String pagePropertyName = this.getParameterNameToUse(this.getPageParameterName(), parameter);
        String sizePropertyName = this.getParameterNameToUse(this.getSizeParameterName(), parameter);
        ArrayList<String> names = new ArrayList<String>();
        MultiValueMap queryParameters = template.getQueryParams();
        boolean existingFound = false;
        for (String propertyName : Arrays.asList(pagePropertyName, sizePropertyName)) {
            if (!queryParameters.containsKey((Object)propertyName)) {
                names.add(propertyName);
                continue;
            }
            existingFound = true;
        }
        String sortTemplateVariables = this.sortResolver.getSortTemplateVariables(parameter, template);
        if (StringUtils.hasText((String)sortTemplateVariables)) {
            names.add(sortTemplateVariables.substring(2, sortTemplateVariables.length() - 1));
        }
        if (names.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(existingFound ? "{&" : "{?");
        builder.append(StringUtils.collectionToCommaDelimitedString(names));
        builder.append("}");
        return builder.toString();
    }

    public void enhance(UriComponentsBuilder builder, MethodParameter parameter, Object value) {
        if (!(value instanceof Pageable)) {
            return;
        }
        Pageable pageable = (Pageable)value;
        String pagePropertyName = this.getParameterNameToUse(this.getPageParameterName(), parameter);
        String sizePropertyName = this.getParameterNameToUse(this.getSizeParameterName(), parameter);
        int pageNumber = pageable.getPageNumber();
        builder.replaceQueryParam(pagePropertyName, new Object[]{this.isOneIndexedParameters() ? pageNumber + 1 : pageNumber});
        builder.replaceQueryParam(sizePropertyName, new Object[]{pageable.getPageSize() <= this.getMaxPageSize() ? pageable.getPageSize() : this.getMaxPageSize()});
        this.sortResolver.enhance(builder, parameter, pageable.getSort());
    }

    private static HateoasSortHandlerMethodArgumentResolver getDefaultedSortResolver(HateoasSortHandlerMethodArgumentResolver sortResolver) {
        return sortResolver == null ? DEFAULT_SORT_RESOLVER : sortResolver;
    }

    static {
        DEFAULT_SORT_RESOLVER = new HateoasSortHandlerMethodArgumentResolver();
        HateoasSortHandlerMethodArgumentResolver LEGACY_SORT = new HateoasSortHandlerMethodArgumentResolver();
        LEGACY_SORT.setLegacyMode(true);
        LEGACY_SORT.setSortParameter("page.sort");
        LEGACY = new HateoasPageableHandlerMethodArgumentResolver(LEGACY_SORT);
        LEGACY.setPageParameterName("page.page");
        LEGACY.setSizeParameterName("page.size");
        LEGACY.setFallbackPageable(new PageRequest(1, 10));
        LEGACY.setOneIndexedParameters(true);
    }
}

