/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.service.weaving.ICachingServiceFactory;
import org.eclipse.equinox.weaving.internal.caching.BundleCachingService;
import org.eclipse.equinox.weaving.internal.caching.CacheItem;
import org.eclipse.equinox.weaving.internal.caching.CacheWriter;
import org.eclipse.equinox.weaving.internal.caching.Log;
import org.eclipse.equinox.weaving.internal.caching.UnchangedCachingService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;

public class CachingServiceFactory
implements ICachingServiceFactory {
    private final Map<String, ICachingService> bundleCachingServices = new HashMap<String, ICachingService>();
    private final BundleContext bundleContext;
    private final BlockingQueue<CacheItem> cacheQueue;
    private final CacheWriter cacheWriter;

    public CachingServiceFactory(BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Argument \"bundleContext\" must not be null!");
        }
        this.bundleContext = bundleContext;
        this.cacheQueue = new ArrayBlockingQueue<CacheItem>(5000);
        this.cacheWriter = new CacheWriter(this.cacheQueue);
        this.cacheWriter.start();
        this.bundleContext.addBundleListener((BundleListener)new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                if (bundleEvent.getType() == 16) {
                    CachingServiceFactory.this.stopBundleCachingService(bundleEvent);
                } else if (bundleEvent.getType() == 8) {
                    CachingServiceFactory.this.stopBundleCachingService(bundleEvent);
                }
            }
        });
    }

    public synchronized ICachingService createCachingService(ClassLoader classLoader, Bundle bundle, String string) {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument \"bundle\" must not be null!");
        }
        String string2 = this.getCacheId(bundle);
        Object object = this.bundleCachingServices.get(string2);
        if (object == null) {
            object = string != null && string.length() > 0 ? new BundleCachingService(this.bundleContext, bundle, string, this.cacheQueue) : new UnchangedCachingService();
            this.bundleCachingServices.put(string2, (ICachingService)object);
            if (Log.isDebugEnabled()) {
                Log.debug(MessageFormat.format("Created BundleCachingService for [{0}].", string2));
            }
        }
        return object;
    }

    public String getCacheId(Bundle bundle) {
        Version version = bundle.getVersion();
        return String.valueOf(bundle.getSymbolicName()) + "_" + version;
    }

    public synchronized void stop() {
        for (ICachingService iCachingService : this.bundleCachingServices.values()) {
            iCachingService.stop();
        }
        this.bundleCachingServices.clear();
        this.cacheWriter.stop();
    }

    protected void stopBundleCachingService(BundleEvent bundleEvent) {
        String string = this.getCacheId(bundleEvent.getBundle());
        ICachingService iCachingService = this.bundleCachingServices.get(string);
        if (iCachingService != null) {
            iCachingService.stop();
            this.bundleCachingServices.remove(string);
        }
    }
}

