/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import java.beans.PropertyChangeEvent;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.model.ui.editors.dnd.ValidationException;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicFieldEditorFactory;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicWizardMessages;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewIonicWidgetWizardPage;
import org.jboss.tools.jst.web.ui.internal.properties.advanced.LayoutUtil;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.JQueryFieldEditorFactory;
import org.jboss.tools.jst.web.ui.palette.html.jquery.wizard.WizardDescriptions;
import org.jboss.tools.jst.web.ui.palette.html.wizard.WizardMessages;

public class NewTextInputWizardPage
extends NewIonicWidgetWizardPage {
    public NewTextInputWizardPage() {
        super("newText", WizardMessages.newTextInputWizardTitle);
        this.setDescription(IonicWizardMessages.newTextInputWizardDescription);
    }

    protected void createFieldPanel(Composite parent) {
        GridData d;
        this.addEditor(JQueryFieldEditorFactory.createTextTypeEditor(), parent);
        this.addEditor(JQueryFieldEditorFactory.createNameEditor(), parent);
        this.addEditor(IonicFieldEditorFactory.createNgModelEditor(), parent);
        this.createSeparator(parent);
        IFieldEditor label = JQueryFieldEditorFactory.createLabelEditor();
        label.setValue((Object)"Input:");
        this.addEditor(label, parent);
        this.addEditor(IonicFieldEditorFactory.createInputLabelStyleEditor(), parent);
        IFieldEditor placeholder = JQueryFieldEditorFactory.createPlaceholderEditor();
        placeholder.setValue((Object)"Text");
        this.addEditor(placeholder, parent);
        this.createSeparator(parent);
        this.addEditor(JQueryFieldEditorFactory.createValueEditor(), parent);
        LayoutUtil.TwoColumns columns = NewTextInputWizardPage.createTwoColumns((Composite)parent);
        this.addEditor(JQueryFieldEditorFactory.createPatternEditor(), columns.left());
        IFieldEditor maxlength = JQueryFieldEditorFactory.createMaxlengthEditor();
        this.addEditor(maxlength, columns.right());
        if (parent != null) {
            Object[] cs = maxlength.getEditorControls();
            d = (GridData)((Text)cs[1]).getLayoutData();
            d.widthHint = 20;
            ((Text)cs[1]).setLayoutData((Object)d);
        }
        Group panel = null;
        if (parent != null) {
            panel = new Group(parent, 2048);
            panel.setText("Number");
            d = new GridData(768);
            d.horizontalSpan = 3;
            panel.setLayoutData((Object)d);
            panel.setLayout((Layout)new GridLayout(3, false));
        }
        Composite[] columns3 = NewTextInputWizardPage.createColumns(panel, (int)3);
        IFieldEditor min = JQueryFieldEditorFactory.createMinEditor((String)WizardDescriptions.textInputMin);
        min.setValue((Object)"");
        this.addEditor(min, columns3[0]);
        IFieldEditor max = JQueryFieldEditorFactory.createMaxEditor((String)WizardDescriptions.textInputMax);
        max.setValue((Object)"");
        this.addEditor(max, columns3[1]);
        IFieldEditor step = JQueryFieldEditorFactory.createStepEditor((String)WizardDescriptions.textInputStep);
        this.addEditor(step, columns3[2]);
        this.createSeparator(parent);
        columns3 = NewTextInputWizardPage.createColumns((Composite)parent, (int)3);
        this.addEditor(JQueryFieldEditorFactory.createRequiredEditor(), columns3[0]);
        this.addEditor(JQueryFieldEditorFactory.createDisabledEditor(), columns3[1]);
        this.addEditor(JQueryFieldEditorFactory.createAutofocusEditor(), columns3[2]);
        this.updateNumberFieldsEnablement();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("text-type".equals(evt.getPropertyName())) {
            this.updateNumberFieldsEnablement();
        }
        super.propertyChange(evt);
    }

    void updateNumberFieldsEnablement() {
        boolean isNumber = "number".equals(this.getEditorValue("text-type"));
        this.setEnabled("min", isNumber);
        this.setEnabled("max", isNumber);
        this.setEnabled("step", isNumber);
    }

    public void validate() throws ValidationException {
        String pattern = this.getEditorValue("pattern");
        if (pattern != null && pattern.length() > 0) {
            try {
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw new ValidationException(e.getMessage());
            }
        }
        super.validate();
    }
}

