/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard;

import org.jboss.tools.common.model.ui.editors.dnd.DropWizardMessages;
import org.jboss.tools.common.model.ui.editors.dnd.IElementGenerator;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.IonicConstants;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewButtonWizardPage;
import org.jboss.tools.jst.angularjs.internal.ionic.palette.wizard.NewIonicWidgetWizard;
import org.jboss.tools.jst.angularjs.internal.ui.AngularJsUIImages;

public class NewButtonWizard
extends NewIonicWidgetWizard<NewButtonWizardPage>
implements IonicConstants {
    public NewButtonWizard() {
        this.setWindowTitle(DropWizardMessages.Wizard_Window_Title);
        this.setDefaultPageImageDescriptor(AngularJsUIImages.getInstance().getOrCreateImageDescriptor(AngularJsUIImages.BUTTON_IMAGE));
    }

    protected NewButtonWizardPage createPage() {
        return new NewButtonWizardPage();
    }

    @Override
    protected void addContent(IElementGenerator.ElementNode parent, boolean browser) {
        if (browser) {
            IElementGenerator.ElementNode div = parent.addChild("div");
            div.addAttribute("style", "padding: 20px 20px 20px 20px;");
            parent = div;
        }
        String tag = ((NewButtonWizardPage)this.page).getEditorValue("button-type");
        IElementGenerator.ElementNode a = parent.addChild(tag, ((NewButtonWizardPage)this.page).getEditorValue("label"));
        this.addID("button-", a);
        this.addButtonAttributes(a);
    }

    private void addButtonAttributes(IElementGenerator.ElementNode a) {
        StringBuilder cls = new StringBuilder();
        cls.append("button");
        String icon = ((NewButtonWizardPage)this.page).getEditorValue("icon");
        if (icon.length() > 0) {
            String iconpos = ((NewButtonWizardPage)this.page).getEditorValue("data-iconpos");
            if (iconpos == null || iconpos.length() == 0) {
                iconpos = "left";
            }
            NewButtonWizard.addClass((StringBuilder)cls, (String)("icon-" + iconpos));
            NewButtonWizard.addClass((StringBuilder)cls, (String)icon);
        }
        this.addClassByEditorID("button-width", cls);
        this.addClassByEditorID("button-size", cls);
        this.addClassByEditorID("button-fill", cls);
        this.addClassByEditorID("bar-color", cls);
        if (this.isTrue("disabled")) {
            a.addAttribute("disabled", "disabled");
        }
        a.addAttribute("class", cls.toString());
    }

    private void addClassByEditorID(String editorID, StringBuilder cls) {
        String value = ((NewButtonWizardPage)this.page).getEditorValue(editorID);
        if (value.length() > 0 && !"none".equals(value)) {
            NewButtonWizard.addClass((StringBuilder)cls, (String)value);
        }
    }
}

