/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.forge.core.furnace;

import bootpath.BootpathMarker;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;
import org.jboss.forge.furnace.se.FurnaceFactory;
import org.jboss.tools.forge.core.furnace.FurnaceService;
import org.jboss.tools.forge.core.furnace.repository.IFurnaceRepository;
import org.jboss.tools.forge.core.internal.ForgeCorePlugin;
import org.jboss.tools.forge.core.internal.furnace.CompositeFurnaceClassLoader;
import org.jboss.tools.forge.core.internal.furnace.repository.FurnaceRepositoryManager;
import org.jboss.tools.forge.core.preferences.ForgeCorePreferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class FurnaceProvider {
    public static final FurnaceProvider INSTANCE = new FurnaceProvider();
    private static final String RUNTIME_PLUGIN_ID = "org.jboss.tools.forge2.runtime";

    private FurnaceProvider() {
    }

    public Furnace createFurnace() throws Exception {
        BundleWiring wiring = (BundleWiring)ForgeCorePlugin.getDefault().getBundle().adapt(BundleWiring.class);
        Collection entries = wiring.listResources("bootpath", "*.jar", 1);
        HashSet<URL> resources = new HashSet<URL>();
        File jarDir = File.createTempFile("forge", "jars");
        if (entries != null) {
            for (String resource : entries) {
                URL jar = BootpathMarker.class.getResource("/" + resource);
                if (jar == null) continue;
                resources.add(this.copy(jarDir, resource, jar.openStream()));
            }
        }
        URLClassLoader furnaceLoader = new URLClassLoader(resources.toArray(new URL[resources.size()]), null);
        FurnaceRepositoryManager repositoryManager = FurnaceRepositoryManager.getDefault();
        List<IFurnaceRepository> repos = repositoryManager.getRepositories();
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        loaders.add(FurnaceProvider.class.getClassLoader());
        loaders.addAll(repositoryManager.getClassLoaders());
        CompositeFurnaceClassLoader compositeLoader = new CompositeFurnaceClassLoader(loaders);
        Furnace furnace = FurnaceFactory.getInstance((ClassLoader)compositeLoader, (ClassLoader)furnaceLoader);
        Bundle runtimeBundle = Platform.getBundle((String)RUNTIME_PLUGIN_ID);
        File bundleFile = FileLocator.getBundleFile((Bundle)runtimeBundle);
        furnace.addRepository(AddonRepositoryMode.IMMUTABLE, new File(bundleFile, "addon-repository"));
        for (IFurnaceRepository repo : repos) {
            furnace.addRepository(repo.getMode(), repo.getRepositoryDirectory());
        }
        furnace.addRepository(AddonRepositoryMode.MUTABLE, new File(ForgeCorePreferences.INSTANCE.getAddonDir()));
        return furnace;
    }

    public void startFurnace() {
        try {
            if (!FurnaceService.INSTANCE.isFurnaceSet()) {
                FurnaceService.INSTANCE.setFurnace(this.createFurnace());
            }
            FurnaceService.INSTANCE.start();
        }
        catch (Exception e) {
            ForgeCorePlugin.log(e);
        }
    }

    private URL copy(File directory, String name, InputStream input) throws IOException {
        File outputFile = new File(directory, name);
        FileOutputStream output = null;
        try {
            try {
                directory.delete();
                outputFile.getParentFile().mkdirs();
                outputFile.createNewFile();
                output = new FileOutputStream(outputFile);
                byte[] buffer = new byte[4096];
                int read = 0;
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
                output.flush();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not write out jar file " + name, e);
            }
        }
        catch (Throwable throwable) {
            this.close(input);
            this.close(output);
            throw throwable;
        }
        this.close(input);
        this.close(output);
        return outputFile.toURI().toURL();
    }

    private void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not close stream", e);
        }
    }
}

